/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.outputdevice.helper;

import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.outputdevice.helper.MinimalFontDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FontFamily<T extends MinimalFontDescription> {
    private List<T> _fontDescriptions;
    private static final int SM_EXACT = 1;
    private static final int SM_LIGHTER_OR_DARKER = 2;
    private static final int SM_DARKER_OR_LIGHTER = 3;

    public List<T> getFontDescriptions() {
        return this._fontDescriptions;
    }

    public void addFontDescription(T descr) {
        if (this._fontDescriptions == null) {
            this._fontDescriptions = new ArrayList<T>();
        }
        this._fontDescriptions.add(descr);
        Collections.sort(this._fontDescriptions, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.getWeight() - o2.getWeight();
            }
        });
    }

    public void setName(String fontFamilyName) {
    }

    public T match(int desiredWeight, IdentValue style) {
        Object result;
        if (this._fontDescriptions == null) {
            throw new RuntimeException("fontDescriptions is null");
        }
        ArrayList<MinimalFontDescription> candidates = new ArrayList<MinimalFontDescription>();
        for (MinimalFontDescription description : this._fontDescriptions) {
            if (description.getStyle() != style) continue;
            candidates.add(description);
        }
        if (candidates.size() == 0) {
            if (style == IdentValue.ITALIC) {
                return this.match(desiredWeight, IdentValue.OBLIQUE);
            }
            if (style == IdentValue.OBLIQUE) {
                return this.match(desiredWeight, IdentValue.NORMAL);
            }
            candidates.addAll(this._fontDescriptions);
        }
        if ((result = this.findByWeight(candidates, desiredWeight, 1)) != null) {
            return (T)result;
        }
        if (desiredWeight <= 500) {
            return (T)this.findByWeight(candidates, desiredWeight, 2);
        }
        return (T)this.findByWeight(candidates, desiredWeight, 3);
    }

    private T findByWeight(List<T> matches, int desiredWeight, int searchMode) {
        if (searchMode == 1) {
            for (MinimalFontDescription descr : matches) {
                if (descr.getWeight() != desiredWeight) continue;
                return (T)descr;
            }
            return null;
        }
        if (searchMode == 2) {
            int offset = 0;
            MinimalFontDescription descr = null;
            for (offset = 0; offset < matches.size() && (descr = (MinimalFontDescription)matches.get(offset)).getWeight() <= desiredWeight; ++offset) {
            }
            if (offset > 0 && descr.getWeight() > desiredWeight) {
                return (T)((MinimalFontDescription)matches.get(offset - 1));
            }
            return (T)descr;
        }
        if (searchMode == 3) {
            int offset = 0;
            MinimalFontDescription descr = null;
            for (offset = matches.size() - 1; offset >= 0 && (descr = (MinimalFontDescription)matches.get(offset)).getWeight() >= desiredWeight; --offset) {
            }
            if (offset != matches.size() - 1 && descr.getWeight() < desiredWeight) {
                return (T)((MinimalFontDescription)matches.get(offset + 1));
            }
            return (T)descr;
        }
        return null;
    }
}

