/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.authentication;

import com.xebialabs.deployit.security.authentication.CustomLdapTemplate;
import javax.naming.directory.SearchControls;
import org.springframework.ldap.core.ContextSource;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;

public class CustomDefaultLdapAuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator {
    private final CustomLdapTemplate customLdapTemplate;
    private final SearchControls searchControls = new SearchControls();

    public CustomDefaultLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase) {
        this(contextSource, groupSearchBase, 100);
    }

    public CustomDefaultLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase, int pageSize) {
        super(contextSource, groupSearchBase);
        this.customLdapTemplate = new CustomLdapTemplate(contextSource, pageSize);
        this.getLdapTemplate().setSearchControls(this.getSearchControls());
    }

    protected SpringSecurityLdapTemplate getLdapTemplate() {
        if (null == this.customLdapTemplate) {
            return super.getLdapTemplate();
        }
        return this.customLdapTemplate;
    }

    public void setSearchSubtree(boolean searchSubtree) {
        super.setSearchSubtree(searchSubtree);
        int searchScope = searchSubtree ? 2 : 1;
        this.searchControls.setSearchScope(searchScope);
    }

    public void setIgnoreSizeLimitExceededException(boolean ignore) {
        this.getLdapTemplate().setIgnoreSizeLimitExceededException(ignore);
    }

    public void setIgnoreNameNotFoundException(boolean ignore) {
        this.getLdapTemplate().setIgnoreNameNotFoundException(ignore);
    }

    private SearchControls getSearchControls() {
        return this.searchControls;
    }
}

