/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service;

import com.xebialabs.deployit.core.rest.dto.NewRulesFileDTO;
import com.xebialabs.deployit.plugin.stitch.service.ChangeSetService;
import com.xebialabs.deployit.plugin.stitch.service.GitOpsService;
import com.xebialabs.deployit.plugin.stitch.service.RuleFileValidationService;
import com.xebialabs.deployit.plugin.stitch.service.RulesFileService;
import com.xebialabs.deployit.plugin.stitch.service.RulesFileService$;
import com.xebialabs.deployit.repository.RepositoryService;
import java.io.File;
import org.eclipse.jgit.api.Git;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Tuple3;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0005A4A!\u0003\u0006\u0001/!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b\u001d\u0003A\u0011\u0001%\t\u000bI\u0003A\u0011I*\t\u000b\r\u0004A\u0011\t3\t\u000b\u0019\u0004A\u0011I4\u0003;I+H.\u001a$jY\u00164\u0016\r\\5eCRLwN\\*feZL7-Z%na2T!a\u0003\u0007\u0002\u000fM,'O^5dK*\u0011QBD\u0001\u0007gRLGo\u00195\u000b\u0005=\u0001\u0012A\u00029mk\u001eLgN\u0003\u0002\u0012%\u0005AA-\u001a9m_fLGO\u0003\u0002\u0014)\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002+\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\ty\u0002%D\u0001\u000b\u0013\t\t#BA\rSk2,g)\u001b7f-\u0006d\u0017\u000eZ1uS>t7+\u001a:wS\u000e,\u0017\u0001\u0005:vY\u0016\u001ch)\u001b7f'\u0016\u0014h/[2f!\tyB%\u0003\u0002&\u0015\t\u0001\"+\u001e7fg\u001aKG.Z*feZL7-\u001a\u0015\u0003\u0003\u001d\u0002\"\u0001K\u001a\u000e\u0003%R!AK\u0016\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002-[\u00059a-Y2u_JL(B\u0001\u00180\u0003\u0015\u0011W-\u00198t\u0015\t\u0001\u0014'A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0011\u0014aA8sO&\u0011A'\u000b\u0002\n\u0003V$xn^5sK\u0012\f\u0001c\u00195b]\u001e,7+\u001a;TKJ4\u0018nY3\u0011\u0005}9\u0014B\u0001\u001d\u000b\u0005A\u0019\u0005.\u00198hKN+GoU3sm&\u001cW\r\u000b\u0002\u0003O\u0005\t\"/\u001a9pg&$xN]=TKJ4\u0018nY3\u0011\u0005qzT\"A\u001f\u000b\u0005y\u0002\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0001)\u0010\u0002\u0012%\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0007FA\u0002(\u000359\u0017\u000e^(qgN+'O^5dKB\u0011q\u0004R\u0005\u0003\u000b*\u0011QbR5u\u001fB\u001c8+\u001a:wS\u000e,\u0007F\u0001\u0003(\u0003\u0019a\u0014N\\5u}Q)\u0011J\u0013'O!B\u0011q\u0004\u0001\u0005\u0006E\u0015\u0001\ra\t\u0015\u0003\u0015\u001eBQ!N\u0003A\u0002YB#\u0001T\u0014\t\u000bi*\u0001\u0019A\u001e)\u00059;\u0003\"\u0002\"\u0006\u0001\u0004\u0019\u0005F\u0001)(\u0003M1\u0018\r\\5eCR,g*Z<Sk2,g)\u001b7f)\t!v\u000b\u0005\u0002\u001a+&\u0011aK\u0007\u0002\u0005+:LG\u000fC\u0003Y\r\u0001\u0007\u0011,A\boK^\u0014V\u000f\\3t\r&dW\r\u0012+P!\tQ\u0016-D\u0001\\\u0015\taV,A\u0002ei>T!AX0\u0002\tI,7\u000f\u001e\u0006\u0003AB\tAaY8sK&\u0011!m\u0017\u0002\u0010\u001d\u0016<(+\u001e7fg\u001aKG.\u001a#U\u001f\u0006Qb/\u00197jI\u0006$XMT3x%VdWMR5mK\u000e{g\u000e^3oiR\u0011A+\u001a\u0005\u00061\u001e\u0001\r!W\u0001\u001fm\u0006d\u0017\u000eZ1uKV\u0003H-\u0019;fIJ+H.\u001a$jY\u0016\u001cuN\u001c;f]R$\"\u0001\u00165\t\u000baC\u0001\u0019A-)\u0005\u0001Q\u0007CA6o\u001b\u0005a'BA70\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0003_2\u0014\u0011bQ8na>tWM\u001c;")
public class RuleFileValidationServiceImpl
implements RuleFileValidationService {
    @Autowired
    private final RulesFileService rulesFileService;
    @Autowired
    private final ChangeSetService changeSetService;
    @Autowired
    private final RepositoryService repositoryService;
    @Autowired
    private final GitOpsService gitOpsService;

    @Override
    public void validateNewRuleFile(NewRulesFileDTO newRulesFileDTO) {
        this.rulesFileService.validateFileNamingConvention(newRulesFileDTO.fileName());
        this.changeSetService.validateBranch(newRulesFileDTO.sourceId(), newRulesFileDTO.branch());
        this.rulesFileService.checkDuplicateFileName(newRulesFileDTO);
    }

    @Override
    public void validateNewRuleFileContent(NewRulesFileDTO newRulesFileDTO) {
        Tuple3<Git, File, String> localRepo = RulesFileService$.MODULE$.prepareLocalRepository(newRulesFileDTO, this.repositoryService, this.gitOpsService);
        try {
            this.validateNewRuleFile(newRulesFileDTO);
            this.rulesFileService.validateSourceWithRule(newRulesFileDTO, localRepo);
        }
        finally {
            this.gitOpsService.clean((Git)localRepo._1(), (File)localRepo._2());
        }
    }

    @Override
    public void validateUpdatedRuleFileContent(NewRulesFileDTO newRulesFileDTO) {
        this.changeSetService.validateBranch(newRulesFileDTO.sourceId(), newRulesFileDTO.branch());
        this.rulesFileService.validateSourceWithRule(newRulesFileDTO);
    }

    public RuleFileValidationServiceImpl(@Autowired RulesFileService rulesFileService, @Autowired ChangeSetService changeSetService, @Autowired RepositoryService repositoryService, @Autowired GitOpsService gitOpsService) {
        this.rulesFileService = rulesFileService;
        this.changeSetService = changeSetService;
        this.repositoryService = repositoryService;
        this.gitOpsService = gitOpsService;
    }
}

