/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Cleaner;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResourceCleaner;
import org.jboss.resteasy.spi.config.Options;
import org.jboss.resteasy.spi.config.SizeUnit;
import org.jboss.resteasy.spi.config.Threshold;

public class EntityOutputStream
extends OutputStream {
    private static final Logger LOGGER = Logger.getLogger(EntityOutputStream.class);
    private static final byte[] EMPTY_BYTES = new byte[0];
    protected final Object lock = new Object();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean exported = new AtomicBoolean();
    private final Threshold memoryThreshold;
    private final Threshold fileThreshold;
    private final Supplier<String> filePrefix;
    private final ByteArrayOutputStream inMemory;
    private final Path tmpDir;
    private volatile Path file;
    private volatile OutputStream delegate;
    private long bytesWritten;

    public EntityOutputStream() {
        this(EntityOutputStream.getOptionValue(Options.ENTITY_MEMORY_THRESHOLD), EntityOutputStream.getTempDir(), () -> "resteasy-entity");
    }

    public EntityOutputStream(Threshold memoryThreshold) {
        this(memoryThreshold, EntityOutputStream.getTempDir(), () -> "resteasy-entity");
    }

    public EntityOutputStream(Threshold memoryThreshold, Supplier<String> filePrefix) {
        this(memoryThreshold, EntityOutputStream.getTempDir(), filePrefix);
    }

    public EntityOutputStream(Threshold memoryThreshold, Path tmpDir, Supplier<String> filePrefix) {
        this(memoryThreshold, tmpDir, EntityOutputStream.getOptionValue(Options.ENTITY_FILE_THRESHOLD), filePrefix);
    }

    public EntityOutputStream(Threshold memoryThreshold, Path tmpDir, Threshold fileThreshold, Supplier<String> filePrefix) {
        this.memoryThreshold = memoryThreshold;
        this.filePrefix = filePrefix;
        this.fileThreshold = fileThreshold;
        if (LOGGER.isDebugEnabled()) {
            Runtime runtime = Runtime.getRuntime();
            long usedMemory = runtime.totalMemory() - runtime.freeMemory();
            long maxMemory = runtime.maxMemory();
            if (usedMemory + memoryThreshold.toBytes() >= maxMemory) {
                LOGGER.debugf(new Throwable("StackTrace for debugging purposes."), "The JVM may run out of memory allocating the memory buffer. The available size is %s with %s used while attempting to allocate %s.", (Object)SizeUnit.toHumanReadable(maxMemory), (Object)SizeUnit.toHumanReadable(usedMemory), (Object)SizeUnit.toHumanReadable(memoryThreshold.toBytes()));
            }
        }
        this.inMemory = new ByteArrayOutputStream();
        this.delegate = this.inMemory;
        this.tmpDir = tmpDir;
        this.bytesWritten = 0L;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException(Messages.MESSAGES.streamIsClosed());
        }
        this.getDelegate(1).write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException(Messages.MESSAGES.streamIsClosed());
        }
        this.getDelegate(b.length).write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException(Messages.MESSAGES.streamIsClosed());
        }
        this.getDelegate(len).write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.delegate.close();
            }
        }
        finally {
            this.closed.set(true);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream toInputStream() throws IOException {
        this.checkExported(Messages.MESSAGES.alreadyExported());
        Object object = this.lock;
        synchronized (object) {
            this.close();
            Path file = this.getFile();
            if (file != null) {
                InputStream in = Files.newInputStream(file, new OpenOption[0]);
                return new EntityInputStream(in, ResourceCleaner.register(in, new FileCleaner(file)));
            }
            return new ByteArrayInputStream(this.getAndClearMemory());
        }
    }

    protected Path getFile() {
        return this.file;
    }

    protected byte[] getAndClearMemory() {
        if (this.file != null) {
            return EMPTY_BYTES;
        }
        try {
            byte[] byArray = this.inMemory.toByteArray();
            return byArray;
        }
        finally {
            this.inMemory.reset();
        }
    }

    protected void checkExported(Supplier<? extends RuntimeException> errorMessage) {
        if (!this.exported.compareAndSet(false, true)) {
            throw errorMessage.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentLength() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.file == null ? (long)this.inMemory.size() : Files.size(this.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream getDelegate(int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.file != null) {
                this.checkFileThreshold(len);
                return this.delegate;
            }
            if (!this.memoryThreshold.reached(len + this.inMemory.size())) {
                return this.delegate;
            }
            this.file = this.tmpDir == null ? Files.createTempFile(this.filePrefix.get(), ".tmp", new FileAttribute[0]) : Files.createTempFile(this.tmpDir, this.filePrefix.get(), ".tmp", new FileAttribute[0]);
            this.bytesWritten = this.inMemory.size();
            this.checkFileThreshold(len);
            OutputStream out = Files.newOutputStream(this.file, StandardOpenOption.CREATE);
            this.inMemory.writeTo(out);
            this.inMemory.reset();
            this.delegate = out;
            return this.delegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileThreshold(int len) {
        Object object = this.lock;
        synchronized (object) {
            if (this.file != null) {
                this.bytesWritten += (long)len;
                if (this.fileThreshold.reached(this.bytesWritten)) {
                    try {
                        this.close();
                    }
                    catch (IOException e) {
                        LOGGER.tracef((Throwable)e, "Failed to close input stream %s", (Object)this);
                    }
                    finally {
                        try {
                            Files.delete(this.file);
                        }
                        catch (IOException e) {
                            LOGGER.tracef((Throwable)e, "Failed to delete file %s", (Object)this.file);
                        }
                    }
                    throw Messages.MESSAGES.fileLimitReached(this.fileThreshold, Options.ENTITY_FILE_THRESHOLD.name());
                }
            }
        }
    }

    private static Path getTempDir() {
        return EntityOutputStream.getOptionValue(Options.ENTITY_TMP_DIR);
    }

    private static <T> T getOptionValue(Options<T> option) {
        if (System.getSecurityManager() == null) {
            return option.getValue();
        }
        return (T)AccessController.doPrivileged(option::getValue);
    }

    private static class EntityInputStream
    extends InputStream {
        private final InputStream delegate;
        private final Cleaner.Cleanable cleanable;

        private EntityInputStream(InputStream delegate, Cleaner.Cleanable cleanable) {
            this.delegate = delegate;
            this.cleanable = cleanable;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public byte[] readAllBytes() throws IOException {
            return this.delegate.readAllBytes();
        }

        @Override
        public byte[] readNBytes(int len) throws IOException {
            return this.delegate.readNBytes(len);
        }

        @Override
        public int readNBytes(byte[] b, int off, int len) throws IOException {
            return this.delegate.readNBytes(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                this.cleanable.clean();
            }
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        public long transferTo(OutputStream out) throws IOException {
            return this.delegate.transferTo(out);
        }
    }

    protected static class FileCleaner
    implements Runnable {
        private final Path path;

        public FileCleaner(Path path) {
            this.path = path;
        }

        @Override
        public void run() {
            try {
                Files.deleteIfExists(this.path);
            }
            catch (IOException e) {
                LogMessages.LOGGER.debugf(e, "Failed to delete file %s", this.path);
            }
        }
    }
}

