/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.xebialabs.license.LicenseParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.util.encoders.HexEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseUtils {
    private static final Logger logger = LoggerFactory.getLogger(LicenseUtils.class);

    private LicenseUtils() {
    }

    public static byte[] readKey(String data) throws IOException {
        HexEncoder hexit = new HexEncoder();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        hexit.decode(data, (OutputStream)bos);
        return bos.toByteArray();
    }

    public static boolean isBase64License(String licenseText) {
        if (licenseText.contains("-") && licenseText.contains(":")) {
            return false;
        }
        if (!licenseText.contains("-") && !licenseText.contains(":")) {
            return true;
        }
        logger.warn("licenseText {} does not contain a - and a :, which is invalid");
        return false;
    }

    public static String decodeBase64License(String data) {
        String decoded;
        String whitespaceRegex = "[\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000]";
        String stripped = data.replaceAll("[\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000]", "");
        try {
            decoded = new String(Base64.decodeBase64((String)stripped), StandardCharsets.UTF_8).replaceAll("\\r\\n?", "\n");
        }
        catch (IllegalArgumentException iae) {
            Throwable cause = iae.getCause();
            if (cause != null) {
                throw new LicenseParseException(data, cause.getMessage());
            }
            throw new LicenseParseException(data, "Parsing license text failed", (Throwable)iae);
        }
        return decoded;
    }

    public static String decodeIfNecessary(String text) {
        if (LicenseUtils.isBase64License(text)) {
            return LicenseUtils.decodeBase64License(text);
        }
        return text;
    }
}

