/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.springframework.data.domain.Page;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class PagedModel<T> {
    private final Page<T> page;

    public PagedModel(Page<T> page) {
        Assert.notNull(page, (String)"Page must not be null");
        this.page = page;
    }

    @JsonProperty
    public List<T> getContent() {
        return this.page.getContent();
    }

    @Nullable
    @JsonProperty(value="page")
    public PageMetadata getMetadata() {
        return new PageMetadata(this.page.getSize(), this.page.getNumber(), this.page.getTotalElements(), this.page.getTotalPages());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PagedModel)) {
            return false;
        }
        PagedModel that = (PagedModel)obj;
        return Objects.equals(this.page, that.page);
    }

    public int hashCode() {
        return Objects.hash(this.page);
    }

    public record PageMetadata(long size, long number, long totalElements, long totalPages) {
        public PageMetadata {
            Assert.isTrue((size > -1L ? 1 : 0) != 0, (String)"Size must not be negative!");
            Assert.isTrue((number > -1L ? 1 : 0) != 0, (String)"Number must not be negative!");
            Assert.isTrue((totalElements > -1L ? 1 : 0) != 0, (String)"Total elements must not be negative!");
            Assert.isTrue((totalPages > -1L ? 1 : 0) != 0, (String)"Total pages must not be negative!");
        }
    }
}

