/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.parsing;

import java.io.Serializable;
import java.util.Locale;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser;
import org.apache.pekko.http.impl.engine.parsing.ParsingException;
import org.apache.pekko.http.impl.engine.parsing.SpecializedHeaderValueParsers$;
import org.apache.pekko.http.impl.engine.parsing.SpecializedHeaderValueParsers$ContentLengthParser$;
import org.apache.pekko.http.impl.engine.parsing.package$;
import org.apache.pekko.http.impl.model.parser.CharacterClasses$;
import org.apache.pekko.http.impl.model.parser.HeaderParser$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.headers.EmptyHeader$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Error$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Ignore$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderValueProcessingMode$Warn$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class HttpHeaderParser$ {
    public static final HttpHeaderParser$ MODULE$ = new HttpHeaderParser$();
    private static final Seq<String> predefinedHeaders = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Accept: *", "Accept: */*", "Connection: Keep-Alive", "Connection: close", "Connection: keep-alive", "Content-Length: 0", "Cache-Control: max-age=0", "Cache-Control: no-cache", "Expect: 100-continue"}));
    private static final Set<String> alwaysParsedHeaders = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"connection", "content-encoding", "content-length", "content-type", "expect", "host", "sec-websocket-key", "sec-websocket-protocol", "sec-websocket-version", "transfer-encoding", "upgrade"}));

    private char[] $lessinit$greater$default$4() {
        return new char[512];
    }

    private int $lessinit$greater$default$5() {
        return 0;
    }

    private short[] $lessinit$greater$default$6() {
        return new short[762];
    }

    private int $lessinit$greater$default$7() {
        return 0;
    }

    private Object[] $lessinit$greater$default$8() {
        return new Object[255];
    }

    private int $lessinit$greater$default$9() {
        return 0;
    }

    public boolean org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$lessinit$greater$default$10() {
        return false;
    }

    private Seq<String> predefinedHeaders() {
        return predefinedHeaders;
    }

    private Set<String> alwaysParsedHeaders() {
        return alwaysParsedHeaders;
    }

    public HttpHeaderParser apply(HttpHeaderParser.Settings settings, LoggingAdapter log) {
        return this.prime(this.unprimed(settings, log, this.defaultIllegalHeaderHandler(settings, log)));
    }

    public Function1<ErrorInfo, BoxedUnit> defaultIllegalHeaderHandler(HttpHeaderParser.Settings settings, LoggingAdapter log) {
        if (settings.illegalHeaderWarnings()) {
            return (Function1 & Serializable)info -> {
                package$.MODULE$.logParsingError(info.withSummaryPrepended("Illegal header"), log, settings.errorLoggingVerbosity(), settings.ignoreIllegalHeaderFor());
                return BoxedUnit.UNIT;
            };
        }
        return (Function1 & Serializable)x$7 -> {
            HttpHeaderParser$.$anonfun$defaultIllegalHeaderHandler$2(x$7);
            return BoxedUnit.UNIT;
        };
    }

    public HttpHeaderParser unprimed(HttpHeaderParser.Settings settings, LoggingAdapter log, Function1<ErrorInfo, BoxedUnit> warnOnIllegalHeader) {
        return new HttpHeaderParser(settings, log, warnOnIllegalHeader, new char[512], 0, new short[762], 0, new Object[255], 0, false);
    }

    public HttpHeaderParser prime(HttpHeaderParser parser) {
        Set<String> headerParserFilter = parser.settings().modeledHeaderParsing() ? x$8 -> BoxesRunTime.boxToBoolean((boolean)HttpHeaderParser$.$anonfun$prime$1(x$8)) : this.alwaysParsedHeaders();
        Seq x$1 = (Seq)((Seq)((IterableOnce)HeaderParser$.MODULE$.ruleNames().filter(headerParserFilter)).iterator().map((Function1 & Serializable)name -> new HttpHeaderParser.ModeledHeaderValueParser((String)name, parser.settings().maxHeaderValueLength(), parser.settings().headerValueCacheLimit((String)name), parser.log(), parser.settings())).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$))).sortBy((Function1 & Serializable)x$9 -> x$9.headerName(), (Ordering)Ordering.String$.MODULE$);
        int x$2 = 0;
        int x$3 = x$1.size();
        this.insertInGoodOrder$1(x$1, x$2, x$3, parser);
        Seq<SpecializedHeaderValueParsers$ContentLengthParser$> x$4 = SpecializedHeaderValueParsers$.MODULE$.specializedHeaderValueParsers();
        int x$5 = 0;
        int x$6 = x$4.size();
        this.insertInGoodOrder$1(x$4, x$5, x$6, parser);
        Seq x$7 = (Seq)this.predefinedHeaders().sorted((Ordering)Ordering.String$.MODULE$);
        int x$82 = 0;
        int x$92 = x$7.size();
        this.insertInGoodOrder$1(x$7, x$82, x$92, parser);
        ByteString x$10 = ByteString$.MODULE$.apply("\r\n");
        EmptyHeader$ x$11 = EmptyHeader$.MODULE$;
        int x$12 = 0;
        int x$13 = x$10.length();
        int x$14 = 0;
        int x$15 = 0;
        parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert(x$10, x$11, x$12, x$13, x$14, x$15);
        ByteString x$16 = ByteString$.MODULE$.apply("\n");
        EmptyHeader$ x$17 = EmptyHeader$.MODULE$;
        int x$18 = 0;
        int x$19 = x$16.length();
        int x$20 = 0;
        int x$21 = 0;
        parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert(x$16, x$17, x$18, x$19, x$20, x$21);
        return parser;
    }

    public void insert(HttpHeaderParser parser, ByteString input, Object value) {
        if (parser == null) {
            throw null;
        }
        int x$3 = 0;
        int x$4 = input.length();
        int x$5 = 0;
        int x$6 = 0;
        parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert(input, value, x$3, x$4, x$5, x$6);
    }

    public void insertRemainingCharsAsNewNodes(HttpHeaderParser parser, ByteString input, Object value) {
        if (parser == null) {
            throw null;
        }
        int x$3 = 0;
        int x$4 = input.length();
        int x$5 = parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$5(input, value);
        int x$6 = 0;
        parser.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(input, value, x$3, x$4, x$5, x$6);
    }

    public Tuple2<String, Object> org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderValue(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode, StringBuilder sb, int ix) {
        block14: while (true) {
            StringBuilder stringBuilder;
            hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().clear();
            if (ix >= limit) break;
            char c = (char)(package$.MODULE$.byteAt(input, ix) & 0xFF);
            switch (c) {
                case '\t': {
                    StringBuilder stringBuilder2 = HttpHeaderParser$.appended$1(' ', sb, input, start, ix);
                    ++ix;
                    sb = stringBuilder2;
                    continue block14;
                }
                case '\r': {
                    int byteChar_ix = ix + 1;
                    if ((char)(package$.MODULE$.byteAt(input, byteChar_ix) & 0xFF) != '\n') break;
                    int byteChar_ix2 = ix + 2;
                    if (CharacterClasses$.MODULE$.WSP().apply((char)(package$.MODULE$.byteAt(input, byteChar_ix2) & 0xFF))) {
                        StringBuilder stringBuilder3 = HttpHeaderParser$.appended$1(' ', sb, input, start, ix);
                        ix += 3;
                        sb = stringBuilder3;
                        continue block14;
                    }
                    return new Tuple2((Object)(sb != null ? sb.toString() : package$.MODULE$.asciiString(input, start, ix)), (Object)BoxesRunTime.boxToInteger((int)(ix + 2)));
                }
                case '\n': {
                    int byteChar_ix = ix + 1;
                    if (CharacterClasses$.MODULE$.WSP().apply((char)(package$.MODULE$.byteAt(input, byteChar_ix) & 0xFF))) {
                        StringBuilder stringBuilder4 = HttpHeaderParser$.appended$1(' ', sb, input, start, ix);
                        ix += 2;
                        sb = stringBuilder4;
                        continue block14;
                    }
                    return new Tuple2((Object)(sb != null ? sb.toString() : package$.MODULE$.asciiString(input, start, ix)), (Object)BoxesRunTime.boxToInteger((int)(ix + 1)));
                }
            }
            int nix = ix + 1;
            if (' ' <= c && c <= '\u007f') {
                stringBuilder = sb != null ? sb.append(c) : null;
            } else if ((c & 0xE0) == 192) {
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c);
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                nix = ix + 2;
                int n = hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                switch (n) {
                    case -1: {
                        if (sb != null) {
                            int byteChar_ix = ix + 1;
                            stringBuilder = sb.append(c).append((char)(package$.MODULE$.byteAt(input, byteChar_ix) & 0xFF));
                            break;
                        }
                        stringBuilder = null;
                        break;
                    }
                    default: {
                        stringBuilder = HttpHeaderParser$.appended2$1(n, sb, input, start, ix);
                        break;
                    }
                }
            } else if ((c & 0xF0) == 224) {
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c);
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 2));
                nix = ix + 3;
                int n = hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                switch (n) {
                    case -1: {
                        if (sb != null) {
                            int byteChar_ix = ix + 1;
                            int byteChar_ix3 = ix + 2;
                            stringBuilder = sb.append(c).append((char)(package$.MODULE$.byteAt(input, byteChar_ix) & 0xFF)).append((char)(package$.MODULE$.byteAt(input, byteChar_ix3) & 0xFF));
                            break;
                        }
                        stringBuilder = null;
                        break;
                    }
                    default: {
                        stringBuilder = HttpHeaderParser$.appended2$1(n, sb, input, start, ix);
                        break;
                    }
                }
            } else if ((c & 0xF8) == 240) {
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put((byte)c);
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 1));
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 2));
                hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().put(package$.MODULE$.byteAt(input, ix + 3));
                nix = ix + 4;
                int n = hhp.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer();
                switch (n) {
                    case -1: {
                        if (sb != null) {
                            int byteChar_ix = ix + 1;
                            int byteChar_ix4 = ix + 2;
                            int byteChar_ix5 = ix + 3;
                            stringBuilder = sb.append(c).append((char)(package$.MODULE$.byteAt(input, byteChar_ix) & 0xFF)).append((char)(package$.MODULE$.byteAt(input, byteChar_ix4) & 0xFF)).append((char)(package$.MODULE$.byteAt(input, byteChar_ix5) & 0xFF));
                            break;
                        }
                        stringBuilder = null;
                        break;
                    }
                    default: {
                        stringBuilder = HttpHeaderParser$.appended2$1(n, sb, input, start, ix);
                        break;
                    }
                }
            } else {
                if (ParserSettings$IllegalResponseHeaderValueProcessingMode$Error$.MODULE$.equals(mode)) {
                    throw this.fail(new StringBuilder(36).append("Illegal character '").append(package$.MODULE$.escape(c)).append("' in header value").toString(), StatusCodes$.MODULE$.BadRequest());
                }
                if (ParserSettings$IllegalResponseHeaderValueProcessingMode$Warn$.MODULE$.equals(mode)) {
                    log.warning(new StringBuilder(36).append("Illegal character '").append(package$.MODULE$.escape(c)).append("' in header value").toString());
                    stringBuilder = sb;
                } else if (ParserSettings$IllegalResponseHeaderValueProcessingMode$Ignore$.MODULE$.equals(mode)) {
                    stringBuilder = sb;
                } else {
                    throw new MatchError((Object)mode);
                }
            }
            StringBuilder nsb = stringBuilder;
            ix = nix;
            sb = nsb;
        }
        throw this.fail(new StringBuilder(61).append("HTTP header value exceeds the configured limit of ").append(limit - start - 2).append(" characters").toString(), StatusCodes$.MODULE$.RequestHeaderFieldsTooLarge());
    }

    public StringBuilder org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderValue$default$7(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode) {
        return null;
    }

    public int org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$scanHeaderValue$default$8(HttpHeaderParser hhp, ByteString input, int start, int limit, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode) {
        return start;
    }

    public Nothing$ fail(String summary, StatusCode status) {
        String apply_detail = "";
        Object var3_3 = null;
        throw new ParsingException(status, new ErrorInfo(summary, apply_detail, ""));
    }

    public StatusCode fail$default$2() {
        return StatusCodes$.MODULE$.BadRequest();
    }

    public char toLowerCase(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c + 32);
        }
        return c;
    }

    public static final /* synthetic */ void $anonfun$defaultIllegalHeaderHandler$2(ErrorInfo x$7) {
    }

    public static final /* synthetic */ boolean $anonfun$prime$1(String x$8) {
        return true;
    }

    private final void insertInGoodOrder$1(Seq items, int startIx, int endIx, HttpHeaderParser parser$1) {
        while (endIx - startIx > 0) {
            int pivot = (startIx + endIx) / 2;
            Object object = items.apply(pivot);
            if (object instanceof HttpHeaderParser.HeaderValueParser) {
                HttpHeaderParser.HeaderValueParser headerValueParser = (HttpHeaderParser.HeaderValueParser)object;
                String insertName = new StringBuilder(11).append(headerValueParser.headerName().toLowerCase(Locale.ROOT)).append(':').toString();
                if (parser$1.isEmpty()) {
                    ByteString x$1 = ByteString$.MODULE$.apply(insertName);
                    int x$3 = 0;
                    int x$4 = x$1.length();
                    int x$5 = parser$1.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$5(x$1, headerValueParser);
                    int x$6 = 0;
                    parser$1.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(x$1, headerValueParser, x$3, x$4, x$5, x$6);
                } else {
                    ByteString x$7 = ByteString$.MODULE$.apply(insertName);
                    int x$9 = 0;
                    int x$10 = x$7.length();
                    int x$11 = 0;
                    int x$12 = 0;
                    parser$1.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert(x$7, headerValueParser, x$9, x$10, x$11, x$12);
                }
            } else if (object instanceof String) {
                String string = (String)object;
                ByteString x$13 = ByteString$.MODULE$.apply(new StringBuilder(3).append(string).append("\r\nx").toString());
                if (parser$1 == null) {
                    throw null;
                }
                int x$14 = 0;
                int x$16 = 0;
                parser$1.parseHeaderLine(x$13, x$14, x$14, x$16);
            } else {
                throw new MatchError(object);
            }
            this.insertInGoodOrder$1(items, startIx, pivot, parser$1);
            startIx = pivot + 1;
        }
    }

    private static final int insertInGoodOrder$default$2$1(Seq items) {
        return 0;
    }

    private static final int insertInGoodOrder$default$3$1(Seq items) {
        return items.size();
    }

    private static final StringBuilder appended$1(char c, StringBuilder sb$2, ByteString input$3, int start$1, int ix$1) {
        return (sb$2 != null ? sb$2 : new StringBuilder(package$.MODULE$.asciiString(input$3, start$1, ix$1))).append(c);
    }

    private static final StringBuilder appended2$1(int c, StringBuilder sb$2, ByteString input$3, int start$1, int ix$1) {
        if (c >> 16 != 0) {
            return HttpHeaderParser$.appended$1((char)c, sb$2, input$3, start$1, ix$1).append((char)(c >> 16));
        }
        return HttpHeaderParser$.appended$1((char)c, sb$2, input$3, start$1, ix$1);
    }

    private HttpHeaderParser$() {
    }
}

