/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.resteasy;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.time.DateTime;

public class Date
implements Comparable<Date> {
    public static final String FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected static final String[] rfc822DateFormats = new String[]{"EEE, dd MMM yy HH:mm:ss z", "EEE, dd MMM yy HH:mm z", "EEE, dd MMM yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm z", "dd MMM yy HH:mm z", "dd MMM yy HH:mm:ss z", "dd MMM yyyy HH:mm z", "dd MMM yyyy HH:mm:ss z", "EEE MMM dd HH:mm:ss zzz yyyy", "EEE, dd MMM yyyy z", "yyyy-MM-dd'T'HH:mm:ss.SSSZ"};
    private Calendar calendar;
    private String dateString;

    public Date(Calendar date) {
        this(date, null);
    }

    public Date(Calendar date, String format) {
        this.calendar = date;
        if (this.calendar != null) {
            this.dateString = format != null ? new SimpleDateFormat(format).format(this.calendar.getTime()) : Date.formatter(rfc822DateFormats[7]).format(this.calendar.getTime());
        }
    }

    private static SimpleDateFormat formatter(String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, Locale.ENGLISH);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    public Date(String dateString) {
        this.dateString = dateString;
        if (dateString != null) {
            this.calendar = Date.parse(dateString);
        }
    }

    public static Date valueOf(String dateString) {
        return new Date(dateString);
    }

    private static Calendar parse(String date) {
        if (date == null) {
            return null;
        }
        for (String each : rfc822DateFormats) {
            try {
                java.util.Date parsedDate = Date.formatter(each).parse(date);
                Calendar cal = Calendar.getInstance(Locale.ENGLISH);
                cal.setTimeZone(TimeZone.getTimeZone("UTC"));
                cal.setTime(parsedDate);
                return cal;
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException(String.format("Cannot parse date %s", date));
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public DateTime asDateTime() {
        return new DateTime((Object)this.calendar);
    }

    @Override
    public int compareTo(Date arg0) {
        return this.calendar.compareTo(arg0.calendar);
    }

    public String toString() {
        return this.dateString;
    }
}

