/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.io;

import com.hierynomus.smbj.io.CachingByteChunkProvider;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferByteChunkProvider
extends CachingByteChunkProvider {
    private ByteBuffer buffer;

    public ByteBufferByteChunkProvider(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBufferByteChunkProvider(ByteBuffer buffer, long fileOffset) {
        this.buffer = buffer;
        this.offset = fileOffset;
    }

    @Override
    int prepareChunk(byte[] chunk, int bytesNeeded) throws IOException {
        int bytesToRead = Math.min(chunk.length, Math.min(bytesNeeded, this.buffer.remaining()));
        if (bytesToRead == 0) {
            return -1;
        }
        this.buffer.get(chunk, 0, bytesToRead);
        return bytesToRead;
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() || this.buffer.hasRemaining();
    }
}

