/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.spi;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.property.access.internal.PropertyAccessStrategyBasicImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyEmbeddedImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyFieldImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMixedImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyNoopImpl;
import org.hibernate.property.access.spi.PropertyAccessStrategy;

public enum BuiltInPropertyAccessStrategies {
    BASIC("property", PropertyAccessStrategyBasicImpl.INSTANCE),
    FIELD("field", PropertyAccessStrategyFieldImpl.INSTANCE),
    MIXED("mixed", PropertyAccessStrategyMixedImpl.INSTANCE),
    MAP("map", PropertyAccessStrategyMapImpl.INSTANCE),
    EMBEDDED("embedded", PropertyAccessStrategyEmbeddedImpl.INSTANCE),
    NOOP("noop", PropertyAccessStrategyNoopImpl.INSTANCE);

    private final @UnknownKeyFor @NonNull @Initialized String externalName;
    private final @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy strategy;

    private BuiltInPropertyAccessStrategies(String externalName, PropertyAccessStrategy strategy) {
        this.externalName = externalName;
        this.strategy = strategy;
    }

    public @UnknownKeyFor @NonNull @Initialized String getExternalName() {
        return this.externalName;
    }

    public @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy getStrategy() {
        return this.strategy;
    }

    public static @Nullable @UnknownKeyFor @Initialized BuiltInPropertyAccessStrategies interpret(@UnknownKeyFor @NonNull @Initialized String name) {
        for (BuiltInPropertyAccessStrategies strategy : BuiltInPropertyAccessStrategies.values()) {
            if (!strategy.externalName.equals(name)) continue;
            return strategy;
        }
        return null;
    }
}

