/*
 * Decompiled with CFR 0.152.
 */
package liquibase.hub.model;

import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.hub.model.HubModel;
import liquibase.util.ISODateFormat;

public class HubChange
implements HubModel {
    private UUID id;
    private String changesetId;
    private String changesetAuthor;
    private String changesetFilename;
    private String description;
    private String comments;
    private String tag;
    private String liquibase;
    private String labels;
    private String contexts;
    private Integer orderExecuted;
    private String md5sum;
    private String execType;
    private String deploymentId;
    private Date dateExecuted;

    public HubChange() {
    }

    public HubChange(RanChangeSet ranChangeSet) {
        this.changesetId = ranChangeSet.getId();
        this.changesetAuthor = ranChangeSet.getAuthor();
        this.changesetFilename = ranChangeSet.getChangeLog();
        this.description = ranChangeSet.getDescription();
        this.comments = ranChangeSet.getComments();
        this.tag = ranChangeSet.getTag();
        this.liquibase = ranChangeSet.getLiquibaseVersion();
        this.orderExecuted = ranChangeSet.getOrderExecuted();
        this.execType = ranChangeSet.getExecType().value;
        this.deploymentId = ranChangeSet.getDeploymentId();
        this.dateExecuted = ranChangeSet.getDateExecuted();
        this.contexts = Objects.toString(ranChangeSet.getContextExpression(), null);
        this.labels = Objects.toString(ranChangeSet.getLabels(), null);
        this.md5sum = Objects.toString(ranChangeSet.getLastCheckSum(), null);
    }

    public HubChange(ChangeSet changeSet) {
        this.changesetId = changeSet.getId();
        this.changesetAuthor = changeSet.getAuthor();
        this.changesetFilename = changeSet.getFilePath();
        this.description = changeSet.getDescription();
        this.comments = changeSet.getComments();
        this.labels = Objects.toString(changeSet.getLabels(), null);
        this.contexts = changeSet.getContextFilter().toString();
        this.orderExecuted = 0;
        this.md5sum = changeSet.generateCheckSum().toString();
        this.execType = "EXECUTED";
        ISODateFormat iso = new ISODateFormat();
        try {
            this.dateExecuted = iso.parse(new Date().toString());
        }
        catch (ParseException pe) {
            this.dateExecuted = new Date();
        }
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getChangesetId() {
        return this.changesetId;
    }

    public void setChangesetId(String changesetId) {
        this.changesetId = changesetId;
    }

    public String getChangesetAuthor() {
        return this.changesetAuthor;
    }

    public void setChangesetAuthor(String changesetAuthor) {
        this.changesetAuthor = changesetAuthor;
    }

    public String getChangesetFilename() {
        return this.changesetFilename;
    }

    public void setChangesetFilename(String changesetFilename) {
        this.changesetFilename = changesetFilename;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getLiquibase() {
        return this.liquibase;
    }

    public void setLiquibase(String liquibase) {
        this.liquibase = liquibase;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public Integer getOrderExecuted() {
        return this.orderExecuted;
    }

    public void setOrderExecuted(Integer orderExecuted) {
        this.orderExecuted = orderExecuted;
    }

    public String getMd5sum() {
        return this.md5sum;
    }

    public void setMd5sum(String md5sum) {
        this.md5sum = md5sum;
    }

    public String getExecType() {
        return this.execType;
    }

    public void setExecType(String execType) {
        this.execType = execType;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public Date getDateExecuted() {
        return this.dateExecuted;
    }

    public void setDateExecuted(Date dateExecuted) {
        this.dateExecuted = dateExecuted;
    }
}

