/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.NotFoundException;
import java.io.IOException;
import java.util.Map;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.servlet.FilterBootstrap;
import org.jboss.resteasy.plugins.server.servlet.HttpRequestFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpResponseFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpServletInputMessage;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper;
import org.jboss.resteasy.plugins.server.servlet.ServletContainerDispatcher;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.Dispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;

public class FilterDispatcher
implements Filter,
HttpRequestFactory,
HttpResponseFactory {
    protected ServletContainerDispatcher servletContainerDispatcher;
    protected ServletContext servletContext;

    public Dispatcher getDispatcher() {
        return this.servletContainerDispatcher.getDispatcher();
    }

    public void init(FilterConfig servletConfig) throws ServletException {
        Map<Class<?>, Object> map = ResteasyContext.getContextDataMap();
        map.put(ServletContext.class, servletConfig.getServletContext());
        map.put(FilterConfig.class, servletConfig);
        this.servletContainerDispatcher = new ServletContainerDispatcher();
        FilterBootstrap bootstrap = new FilterBootstrap(servletConfig);
        this.servletContext = servletConfig.getServletContext();
        this.servletContainerDispatcher.init(this.servletContext, bootstrap, this, this);
        this.servletContainerDispatcher.getDispatcher().getDefaultContextObjects().put(FilterConfig.class, servletConfig);
    }

    @Override
    public HttpRequest createResteasyHttpRequest(String httpMethod, HttpServletRequest request, ResteasyHttpHeaders headers, ResteasyUriInfo uriInfo, HttpResponse theResponse, HttpServletResponse response) {
        return new HttpServletInputMessage(request, response, this.servletContext, theResponse, headers, uriInfo, httpMethod.toUpperCase(), (SynchronousDispatcher)this.getDispatcher());
    }

    @Override
    public HttpResponse createResteasyHttpResponse(HttpServletResponse response, HttpServletRequest request) {
        return new HttpServletResponseWrapper(response, request, this.getDispatcher().getProviderFactory());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            this.servletContainerDispatcher.service(((HttpServletRequest)servletRequest).getMethod(), (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, false);
        }
        catch (NotFoundException e) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
        this.servletContainerDispatcher.destroy();
    }
}

