/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.spi.orchestration;

import com.xebialabs.deployit.engine.spi.orchestration.Orchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecificationWithDependencies;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Orchestrator {
    @Deprecated
    default public Orchestration orchestrate(DeltaSpecification specification) {
        throw new UnsupportedOperationException("This method is deprecated and should not be used");
    }

    default public Orchestration orchestrate(DeltaSpecificationWithDependencies specificationWithDependencies) {
        List allDeltaSpecifications = specificationWithDependencies.getAllDeltaSpecifications();
        if (allDeltaSpecifications.size() == 1) {
            return this.orchestrate((DeltaSpecification)allDeltaSpecifications.get(0));
        }
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.warn("This orchestrator is not implemented for application dependencies. Please implement method orchestrate(DeltaSpecificationWithDependencies specificationWithDependencies)");
        logger.warn("Falling back to sequential by application dependency orchestration");
        Stream<Orchestration> orchestrationStream = allDeltaSpecifications.stream().map(this::orchestrate);
        String description = allDeltaSpecifications.stream().map(ds -> ds.getDeployedApplication().getName()).collect(Collectors.joining(", ", "Deploying applications ", ""));
        return Orchestrations.serial(description, orchestrationStream.collect(Collectors.toList()));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Metadata {
        public String name();

        public String description() default "";
    }
}

