/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.gcp.credentials;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.xebialabs.overthere.gcp.credentials.GcpCredentialFactory;
import com.xebialabs.overthere.gcp.credentials.ProjectCredentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class ServiceAccountFileGcpCredentialFactory
extends GcpCredentialFactory {
    private final File credentialsFile;

    ServiceAccountFileGcpCredentialFactory(File credentialsFile) {
        this.credentialsFile = credentialsFile;
    }

    @Override
    protected ProjectCredentials doCreate() {
        try {
            ServiceAccountCredentials serviceAccountCredentials = ServiceAccountCredentials.fromStream((InputStream)new FileInputStream(this.credentialsFile));
            return new ProjectCredentials((Credentials)serviceAccountCredentials, serviceAccountCredentials.getProjectId(), serviceAccountCredentials.getClientEmail());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load credentials file " + this.credentialsFile.getAbsolutePath(), e);
        }
    }

    @Override
    public String info() {
        return "credentials file " + this.credentialsFile.getAbsolutePath();
    }
}

