/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.rest;

import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.rest.FormatFactory;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

@Provider
@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
public class CiReaderWriter
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    private Repository repository;
    protected FormatFactory formats = new FormatFactory();

    public CiReaderWriter(Repository repository) {
        this.repository = repository;
    }

    protected ConfigurationItemConverter createConverter() {
        return new ConfigurationItemConverter();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadable(type, genericType, annotations, mediaType);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object ci, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        int level = this.getCiRefsFromLevel();
        ConfigurationItemConverter converter = this.createConverter();
        CiWriter writer = this.formats.createCiWriter(mediaType);
        if (Collection.class.isAssignableFrom(type)) {
            converter.writeCis((Collection)ci, writer, level);
        } else if (ConfigurationItem.class.isAssignableFrom(type)) {
            converter.writeCi((ConfigurationItem)ci, writer, level);
        } else {
            throw new IllegalArgumentException("Can't write objects of type " + type.getName());
        }
        entityStream.write(writer.toString().getBytes());
    }

    protected int getCiRefsFromLevel() {
        return 0;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        return ConfigurationItem.class.isAssignableFrom(type);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ConfigurationItemConverter converter = this.createConverter();
        ConfigurationItem result = null;
        if (Collection.class.isAssignableFrom(type)) {
            CiListReader reader = this.formats.createCiListReader(entityStream, mediaType);
            result = converter.readCis(reader);
        } else {
            CiReader reader = this.formats.createCiReader(entityStream, mediaType);
            result = converter.readCi(reader);
        }
        converter.resolveReferences(this.repository);
        return result;
    }
}

