/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Objects;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.query.BindableType;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmParameter;

public class JpaCriteriaParameter<T>
extends AbstractSqmExpression<T>
implements SqmParameter<T>,
QueryParameterImplementor<T> {
    private final String name;
    private boolean allowsMultiValuedBinding;

    public JpaCriteriaParameter(String name, BindableType<? super T> type, boolean allowsMultiValuedBinding, NodeBuilder nodeBuilder) {
        super(JpaCriteriaParameter.toSqmType(type, nodeBuilder), nodeBuilder);
        this.name = name;
        this.allowsMultiValuedBinding = allowsMultiValuedBinding;
    }

    protected JpaCriteriaParameter(JpaCriteriaParameter<T> original) {
        super(original.getNodeType(), original.nodeBuilder());
        this.name = original.name;
        this.allowsMultiValuedBinding = original.allowsMultiValuedBinding;
    }

    private static <T> SqmExpressible<T> toSqmType(BindableType<T> type, NodeBuilder nodeBuilder) {
        if (type == null) {
            return null;
        }
        return type.resolveExpressible(nodeBuilder.getSessionFactory());
    }

    @Override
    public JpaCriteriaParameter<T> copy(SqmCopyContext context) {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public T getValue() {
        return null;
    }

    @Override
    public Integer getPosition() {
        return null;
    }

    @Override
    public Integer getTupleLength() {
        return null;
    }

    @Override
    public boolean allowsMultiValuedBinding() {
        return this.allowsMultiValuedBinding;
    }

    @Override
    public void disallowMultiValuedBinding() {
        this.allowsMultiValuedBinding = false;
    }

    @Override
    public boolean allowMultiValuedBinding() {
        return this.allowsMultiValuedBinding();
    }

    @Override
    public BindableType<T> getAnticipatedType() {
        return this.getHibernateType();
    }

    @Override
    public void applyAnticipatedType(BindableType type) {
        super.internalApplyInferableType(JpaCriteriaParameter.toSqmType(type, this.nodeBuilder()));
    }

    @Override
    public SqmParameter<T> copy() {
        return new JpaCriteriaParameter<T>(this.getName(), this.getAnticipatedType(), this.allowMultiValuedBinding(), this.nodeBuilder());
    }

    @Override
    public BindableType<T> getHibernateType() {
        return this.getNodeType();
    }

    public Class<T> getParameterType() {
        SqmExpressible nodeType = this.getNodeType();
        return nodeType == null ? null : nodeType.getExpressibleJavaType().getJavaTypeClass();
    }

    @Override
    protected void internalApplyInferableType(SqmExpressible<?> newType) {
        super.internalApplyInferableType(newType);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitJpaCriteriaParameter(this);
    }

    @Override
    public NamedCallableQueryMemento.ParameterMemento toMemento() {
        throw new UnsupportedOperationException("ParameterMemento cannot be extracted from Criteria query parameter");
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(':');
        sb.append(this.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpaCriteriaParameter parameter = (JpaCriteriaParameter)o;
        return Objects.equals(this.name, parameter.name);
    }

    public int hashCode() {
        if (this.name == null) {
            return super.hashCode();
        }
        return Objects.hash(this.name);
    }

    @Override
    public int compareTo(SqmParameter anotherParameter) {
        return anotherParameter instanceof JpaCriteriaParameter ? Integer.compare(this.hashCode(), anotherParameter.hashCode()) : 1;
    }
}

