/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.aot.hint;

import java.util.Arrays;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;

class CommonSessionSecurityRuntimeHints
implements RuntimeHintsRegistrar {
    CommonSessionSecurityRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        this.registerSecurityHintsIfNeeded(hints);
        this.registerOAuth2ClientHintsIfNeeded(hints);
        this.registerOAuth2ResourceServerHintsIfNeeded(hints);
    }

    private void registerSecurityHintsIfNeeded(RuntimeHints hints) {
        Arrays.asList(TypeReference.of((String)"org.springframework.security.core.context.SecurityContextImpl"), TypeReference.of((String)"org.springframework.security.core.authority.SimpleGrantedAuthority"), TypeReference.of((String)"org.springframework.security.core.userdetails.User"), TypeReference.of((String)"org.springframework.security.authentication.AbstractAuthenticationToken"), TypeReference.of((String)"org.springframework.security.authentication.UsernamePasswordAuthenticationToken"), TypeReference.of((String)"org.springframework.security.core.AuthenticationException"), TypeReference.of((String)"org.springframework.security.authentication.BadCredentialsException"), TypeReference.of((String)"org.springframework.security.core.userdetails.UsernameNotFoundException"), TypeReference.of((String)"org.springframework.security.authentication.AccountExpiredException"), TypeReference.of((String)"org.springframework.security.authentication.ProviderNotFoundException"), TypeReference.of((String)"org.springframework.security.authentication.DisabledException"), TypeReference.of((String)"org.springframework.security.authentication.LockedException"), TypeReference.of((String)"org.springframework.security.authentication.AuthenticationServiceException"), TypeReference.of((String)"org.springframework.security.authentication.CredentialsExpiredException"), TypeReference.of((String)"org.springframework.security.authentication.InsufficientAuthenticationException"), TypeReference.of((String)"org.springframework.security.web.authentication.session.SessionAuthenticationException"), TypeReference.of((String)"org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException"), TypeReference.of((String)"org.springframework.security.core.userdetails.User$AuthorityComparator")).forEach(type -> hints.serialization().registerType(type, hint -> hint.onReachableType(TypeReference.of((String)"org.springframework.security.core.context.SecurityContextImpl"))));
    }

    private void registerOAuth2ResourceServerHintsIfNeeded(RuntimeHints hints) {
        Arrays.asList(TypeReference.of((String)"org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken"), TypeReference.of((String)"org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken"), TypeReference.of((String)"org.springframework.security.oauth2.core.OAuth2AuthenticationException")).forEach(type -> hints.serialization().registerType(type, hint -> hint.onReachableType(TypeReference.of((String)"org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken"))));
    }

    private void registerOAuth2ClientHintsIfNeeded(RuntimeHints hints) {
        Arrays.asList(TypeReference.of((String)"org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken"), TypeReference.of((String)"org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken"), TypeReference.of((String)"org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeAuthenticationToken"), TypeReference.of((String)"org.springframework.security.oauth2.core.OAuth2AuthenticationException")).forEach(type -> hints.serialization().registerType(type, hint -> hint.onReachableType(TypeReference.of((String)"org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken"))));
    }
}

