/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.google.cloud.secretmanager.v1.Secret;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.GoogleSecretManagerEnvironmentProperties;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleConfigProvider;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleSecretComparatorByVersion;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleSecretManagerAccessStrategy;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleSecretManagerAccessStrategyFactory;
import org.springframework.cloud.config.server.environment.secretmanager.HttpHeaderGoogleConfigProvider;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class GoogleSecretManagerEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private String applicationLabel;
    private String profileLabel;
    private GoogleSecretManagerAccessStrategy accessStrategy;
    private boolean tokenMandatory;
    private GoogleConfigProvider configProvider;
    private final int order;

    public GoogleSecretManagerEnvironmentRepository(ObjectProvider<HttpServletRequest> request, RestTemplate rest, GoogleSecretManagerEnvironmentProperties properties) {
        this.applicationLabel = properties.getApplicationLabel();
        this.profileLabel = properties.getProfileLabel();
        this.configProvider = new HttpHeaderGoogleConfigProvider(request);
        this.accessStrategy = GoogleSecretManagerAccessStrategyFactory.forVersion(rest, this.configProvider, properties);
        this.tokenMandatory = properties.getTokenMandatory();
        this.order = properties.getOrder();
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        if (!StringUtils.hasText((String)label)) {
            label = "master";
        }
        if (!StringUtils.hasText((String)profile)) {
            profile = "default";
        }
        if (!((String)profile).startsWith("default")) {
            profile = "default," + (String)profile;
        }
        String[] profiles = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)profile));
        Environment result = new Environment(application, new String[]{profile, label, null, null});
        if (this.tokenMandatory) {
            if (this.accessStrategy.checkRemotePermissions().booleanValue()) {
                this.addPropertySource(application, profiles, result);
            }
        } else {
            this.addPropertySource(application, profiles, result);
        }
        return result;
    }

    private void addPropertySource(String application, String[] profiles, Environment result) {
        for (String profileUnit : profiles) {
            Map<?, ?> secrets = this.getSecrets(application, profileUnit);
            if (secrets.isEmpty()) continue;
            result.add(new PropertySource("gsm:" + application + "-" + profileUnit, secrets));
        }
    }

    private Map<?, ?> getSecrets(String application, String profile) {
        HashMap<String, String> result = new HashMap<String, String>();
        String prefix = this.configProvider.getValue("X-Secret-Prefix", false);
        for (Secret secret : this.accessStrategy.getSecrets()) {
            if (secret.getLabelsOrDefault(this.applicationLabel, "application").equalsIgnoreCase(application) && secret.getLabelsOrDefault(this.profileLabel, "profile").equalsIgnoreCase(profile)) {
                result.put(this.accessStrategy.getSecretName(secret), this.accessStrategy.getSecretValue(secret, new GoogleSecretComparatorByVersion()));
                continue;
            }
            if (!StringUtils.hasText((String)prefix) || !this.accessStrategy.getSecretName(secret).startsWith(prefix)) continue;
            String secretName = this.accessStrategy.getSecretName(secret);
            if (secretName.startsWith(prefix)) {
                secretName = secretName.replaceFirst(prefix, "");
            }
            result.put(secretName, this.accessStrategy.getSecretValue(secret, new GoogleSecretComparatorByVersion()));
        }
        return result;
    }

    public int getOrder() {
        return this.order;
    }
}

