/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ModuleInfo;

public final class StackedIndex
implements IndexView {
    private final IndexView[] stack;

    private StackedIndex(IndexView[] stack) {
        this.stack = stack;
    }

    public static StackedIndex create(List<IndexView> indexes) {
        return StackedIndex.create(indexes.toArray(new IndexView[0]));
    }

    public static StackedIndex create(IndexView ... indexes) {
        Objects.requireNonNull(indexes);
        ArrayList<IndexView> stack = new ArrayList<IndexView>();
        for (int i = indexes.length - 1; i >= 0; --i) {
            IndexView index = indexes[i];
            Objects.requireNonNull(index);
            if (index instanceof StackedIndex) {
                Collections.addAll(stack, ((StackedIndex)index).stack);
                continue;
            }
            stack.add(index);
        }
        return new StackedIndex(stack.toArray(new IndexView[0]));
    }

    public StackedIndex pushIndex(IndexView index) {
        IndexView[] newStack;
        if (index instanceof StackedIndex) {
            IndexView[] indexes = ((StackedIndex)index).stack;
            newStack = new IndexView[indexes.length + this.stack.length];
            System.arraycopy(indexes, 0, newStack, 0, indexes.length);
            System.arraycopy(this.stack, 0, newStack, indexes.length, this.stack.length);
        } else {
            newStack = new IndexView[1 + this.stack.length];
            newStack[0] = index;
            System.arraycopy(this.stack, 0, newStack, 1, this.stack.length);
        }
        return new StackedIndex(newStack);
    }

    @Override
    public Collection<ClassInfo> getKnownClasses() {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        HashSet<DotName> seen = new HashSet<DotName>();
        for (IndexView idx : this.stack) {
            for (ClassInfo clazz : idx.getKnownClasses()) {
                if (!seen.add(clazz.name())) continue;
                result.add(clazz);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public ClassInfo getClassByName(DotName className) {
        for (IndexView index : this.stack) {
            ClassInfo result = index.getClassByName(className);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Collection<ClassInfo> getKnownDirectSubclasses(DotName className) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        HashSet<DotName> seen = new HashSet<DotName>();
        for (IndexView idx : this.stack) {
            for (ClassInfo clazz : idx.getKnownDirectSubclasses(className)) {
                if (!seen.add(clazz.name())) continue;
                result.add(clazz);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<ClassInfo> getAllKnownSubclasses(DotName className) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        ArrayDeque<DotName> worklist = new ArrayDeque<DotName>();
        HashSet<DotName> seen = new HashSet<DotName>();
        worklist.add(className);
        while (!worklist.isEmpty()) {
            DotName cls = (DotName)worklist.remove();
            for (IndexView index : this.stack) {
                for (ClassInfo directSubclass : index.getKnownDirectSubclasses(cls)) {
                    worklist.add(directSubclass.name());
                    if (!seen.add(directSubclass.name())) continue;
                    result.add(directSubclass);
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<ClassInfo> getKnownDirectSubinterfaces(DotName interfaceName) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        HashSet<DotName> seen = new HashSet<DotName>();
        for (IndexView idx : this.stack) {
            for (ClassInfo clazz : idx.getKnownDirectSubinterfaces(interfaceName)) {
                if (!seen.add(clazz.name())) continue;
                result.add(clazz);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<ClassInfo> getAllKnownSubinterfaces(DotName interfaceName) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        ArrayDeque<DotName> worklist = new ArrayDeque<DotName>();
        HashSet<DotName> seen = new HashSet<DotName>();
        worklist.add(interfaceName);
        while (!worklist.isEmpty()) {
            DotName iface = (DotName)worklist.remove();
            for (IndexView index : this.stack) {
                for (ClassInfo directSubinterface : index.getKnownDirectSubinterfaces(iface)) {
                    worklist.add(directSubinterface.name());
                    if (!seen.add(directSubinterface.name())) continue;
                    result.add(directSubinterface);
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<ClassInfo> getKnownDirectImplementors(DotName interfaceName) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        HashSet<DotName> seen = new HashSet<DotName>();
        for (IndexView idx : this.stack) {
            for (ClassInfo clazz : idx.getKnownDirectImplementors(interfaceName)) {
                if (!seen.add(clazz.name())) continue;
                result.add(clazz);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<ClassInfo> getAllKnownImplementors(DotName interfaceName) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        ArrayDeque<DotName> worklist = new ArrayDeque<DotName>();
        HashSet<DotName> seen = new HashSet<DotName>();
        worklist.add(interfaceName);
        while (!worklist.isEmpty()) {
            DotName iface = (DotName)worklist.remove();
            for (IndexView index : this.stack) {
                for (ClassInfo directImplementor : index.getKnownDirectImplementors(iface)) {
                    if (directImplementor.isInterface()) {
                        worklist.add(directImplementor.name());
                        continue;
                    }
                    if (!seen.add(directImplementor.name())) continue;
                    result.add(directImplementor);
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<AnnotationInstance> getAnnotations(DotName annotationName) {
        ArrayList<AnnotationInstance> result = new ArrayList<AnnotationInstance>();
        HashSet seen = new HashSet();
        HashSet<DotName> seenInThisIteration = new HashSet<DotName>();
        for (IndexView idx : this.stack) {
            for (AnnotationInstance annotation : idx.getAnnotations(annotationName)) {
                DotName inClass = StackedIndex.nameOfDeclaringClass(annotation.target());
                if (inClass == null || seen.contains(inClass)) continue;
                result.add(annotation);
                seenInThisIteration.add(inClass);
            }
            seen.addAll(seenInThisIteration);
            seenInThisIteration.clear();
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<AnnotationInstance> getAnnotationsWithRepeatable(DotName annotationName, IndexView index) {
        ArrayList<AnnotationInstance> result = new ArrayList<AnnotationInstance>();
        HashSet seen = new HashSet();
        HashSet<DotName> seenInThisIteration = new HashSet<DotName>();
        for (IndexView idx : this.stack) {
            for (AnnotationInstance annotation : idx.getAnnotationsWithRepeatable(annotationName, index)) {
                DotName inClass = StackedIndex.nameOfDeclaringClass(annotation.target());
                if (inClass == null || seen.contains(inClass)) continue;
                result.add(annotation);
                seenInThisIteration.add(inClass);
            }
            seen.addAll(seenInThisIteration);
            seenInThisIteration.clear();
        }
        return Collections.unmodifiableList(result);
    }

    private static DotName nameOfDeclaringClass(AnnotationTarget target) {
        if (target == null) {
            return null;
        }
        if (target.kind() == AnnotationTarget.Kind.CLASS) {
            return target.asClass().name();
        }
        if (target.kind() == AnnotationTarget.Kind.METHOD) {
            return target.asMethod().declaringClass().name();
        }
        if (target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
            return target.asMethodParameter().method().declaringClass().name();
        }
        if (target.kind() == AnnotationTarget.Kind.FIELD) {
            return target.asField().declaringClass().name();
        }
        if (target.kind() == AnnotationTarget.Kind.RECORD_COMPONENT) {
            return target.asRecordComponent().declaringClass().name();
        }
        if (target.kind() == AnnotationTarget.Kind.TYPE) {
            return StackedIndex.nameOfDeclaringClass(target.asType().enclosingTarget());
        }
        throw new IllegalArgumentException("Unknown annotation target: " + target);
    }

    @Override
    public Collection<ModuleInfo> getKnownModules() {
        ArrayList<ModuleInfo> result = new ArrayList<ModuleInfo>();
        HashSet<DotName> seen = new HashSet<DotName>();
        for (IndexView idx : this.stack) {
            for (ModuleInfo module : idx.getKnownModules()) {
                if (!seen.add(module.name())) continue;
                result.add(module);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public ModuleInfo getModuleByName(DotName moduleName) {
        for (IndexView idx : this.stack) {
            ModuleInfo result = idx.getModuleByName(moduleName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Collection<ClassInfo> getKnownUsers(DotName className) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        HashSet<DotName> seen = new HashSet<DotName>();
        for (IndexView idx : this.stack) {
            for (ClassInfo clazz : idx.getKnownUsers(className)) {
                if (!seen.add(clazz.name())) continue;
                result.add(clazz);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<ClassInfo> getClassesInPackage(DotName packageName) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        HashSet<DotName> seen = new HashSet<DotName>();
        for (IndexView idx : this.stack) {
            for (ClassInfo clazz : idx.getClassesInPackage(packageName)) {
                if (!seen.add(clazz.name())) continue;
                result.add(clazz);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Set<DotName> getSubpackages(DotName packageName) {
        HashSet<DotName> result = new HashSet<DotName>();
        for (IndexView idx : this.stack) {
            result.addAll(idx.getSubpackages(packageName));
        }
        return Collections.unmodifiableSet(result);
    }
}

