/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.WriterException;

@Provider
@Produces(value={"multipart/mixed"})
@Consumes(value={"multipart/mixed", "multipart/form-data"})
public class MimeMultipartProvider
extends AbstractEntityProvider<MimeMultipart> {
    public static DataSource readDataSource(InputStream in, MediaType mediaType) throws IOException {
        ByteArrayDataSource ds = new ByteArrayDataSource((InputStream)new BufferedInputStream(in), mediaType.toString());
        return ds;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MimeMultipart.class.equals(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MimeMultipart.class.equals(type);
    }

    public MimeMultipart readFrom(Class<MimeMultipart> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", (Object)((Object)((Object)this)).getClass().getName());
            DataSource ds = MimeMultipartProvider.readDataSource(entityStream, mediaType);
            return new MimeMultipart(ds);
        }
        catch (MessagingException e) {
            throw new ReaderException((Throwable)e);
        }
    }

    public void writeTo(MimeMultipart mimeMultipart, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)((Object)((Object)this)).getClass().getName());
            httpHeaders.putSingle((Object)"Content-Type", (Object)MediaType.valueOf((String)mimeMultipart.getContentType()));
            mimeMultipart.writeTo(entityStream);
        }
        catch (MessagingException e) {
            throw new WriterException((Throwable)e);
        }
    }

    public CompletionStage<Void> asyncWriteTo(MimeMultipart mimeMultipart, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        try {
            LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)((Object)((Object)this)).getClass().getName());
            httpHeaders.putSingle((Object)"Content-Type", (Object)MediaType.valueOf((String)mimeMultipart.getContentType()));
            ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
            mimeMultipart.writeTo((OutputStream)bos);
            return entityStream.asyncWrite(bos.toByteArray());
        }
        catch (MessagingException | IOException e) {
            return ProviderHelper.completedException((Throwable)new WriterException(e));
        }
    }
}

