/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.DelegatingQueryRewriter;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.QueryRewriterProvider;
import org.springframework.data.util.Lazy;

public class BeanFactoryQueryRewriterProvider
implements QueryRewriterProvider {
    private final BeanFactory beanFactory;

    public BeanFactoryQueryRewriterProvider(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public QueryRewriter getQueryRewriter(JpaQueryMethod method) {
        Class<? extends QueryRewriter> queryRewriter = method.getQueryRewriter();
        if (queryRewriter == QueryRewriter.IdentityQueryRewriter.class) {
            return QueryRewriter.IdentityQueryRewriter.INSTANCE;
        }
        Lazy rewriter = Lazy.of(() -> (QueryRewriter)this.beanFactory.getBeanProvider(queryRewriter).getIfAvailable(() -> (QueryRewriter)BeanUtils.instantiateClass((Class)queryRewriter)));
        return new DelegatingQueryRewriter((Supplier<QueryRewriter>)rewriter);
    }
}

