/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.vfs2.provider.sftp.IdentityProvider;
import org.apache.commons.vfs2.provider.sftp.Utils;

public class BytesIdentityInfo
implements IdentityProvider {
    private final byte[] passphrase;
    private final byte[] privateKey;
    private final byte[] publicKey;

    public BytesIdentityInfo(byte[] privateKey, byte[] passphrase) {
        this(privateKey, null, passphrase);
    }

    public BytesIdentityInfo(byte[] privateKey, byte[] publicKey, byte[] passphrase) {
        this.privateKey = Utils.clone(privateKey);
        this.publicKey = Utils.clone(publicKey);
        this.passphrase = Utils.clone(passphrase);
    }

    @Override
    public void addIdentity(JSch jsch) throws JSchException {
        jsch.addIdentity("PrivateKey", this.privateKey, this.publicKey, this.passphrase);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BytesIdentityInfo)) {
            return false;
        }
        BytesIdentityInfo other = (BytesIdentityInfo)obj;
        return Arrays.equals(this.passphrase, other.passphrase) && Arrays.equals(this.privateKey, other.privateKey) && Arrays.equals(this.publicKey, other.publicKey);
    }

    public byte[] getPassphrase() {
        return Utils.clone(this.passphrase);
    }

    @Deprecated
    public byte[] getPassPhrase() {
        return Utils.clone(this.passphrase);
    }

    public byte[] getPrivateKeyBytes() {
        return Utils.clone(this.privateKey);
    }

    public byte[] getPublicKeyBytes() {
        return Utils.clone(this.publicKey);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.passphrase), Arrays.hashCode(this.privateKey), Arrays.hashCode(this.publicKey));
    }
}

