/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.function.BiConsumer;
import org.hibernate.collection.spi.PersistentArrayHolder;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class CollectionAssembler
implements DomainResultAssembler {
    private final PluralAttributeMapping fetchedMapping;
    protected final CollectionInitializer<?> initializer;

    public CollectionAssembler(PluralAttributeMapping fetchedMapping, CollectionInitializer<?> initializer) {
        this.fetchedMapping = fetchedMapping;
        this.initializer = initializer;
    }

    public Object assemble(RowProcessingState rowProcessingState) {
        assert (((InitializerData)this.initializer.getData(rowProcessingState)).getState() != Initializer.State.UNINITIALIZED && ((InitializerData)this.initializer.getData(rowProcessingState)).getState() != Initializer.State.KEY_RESOLVED);
        PersistentCollection<?> collectionInstance = this.initializer.getCollectionInstance(rowProcessingState);
        if (collectionInstance instanceof PersistentArrayHolder) {
            return collectionInstance.getValue();
        }
        return collectionInstance;
    }

    public JavaType<?> getAssembledJavaType() {
        return this.fetchedMapping.getJavaType();
    }

    public CollectionInitializer<?> getInitializer() {
        return this.initializer;
    }

    @Override
    public void resolveState(RowProcessingState rowProcessingState) {
        this.initializer.resolveState(rowProcessingState);
    }

    public void forEachResultAssembler(BiConsumer consumer, Object arg) {
        if (this.initializer.isResultInitializer()) {
            consumer.accept(this.initializer, arg);
        }
    }
}

