/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.authentication;

import io.micrometer.observation.ObservationRegistry;
import java.util.Arrays;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ObservationAuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;

public class AuthenticationManagerFactoryBean
implements FactoryBean<AuthenticationManager>,
BeanFactoryAware {
    private BeanFactory bf;
    private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
    public static final String MISSING_BEAN_ERROR_MESSAGE = "Did you forget to add a global <authentication-manager> element to your configuration (with child <authentication-provider> elements)? Alternatively you can use the authentication-manager-ref attribute on your <http> and <global-method-security> elements.";

    public AuthenticationManager getObject() throws Exception {
        try {
            return (AuthenticationManager)this.bf.getBean("org.springframework.security.authenticationManager");
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (!"org.springframework.security.authenticationManager".equals(ex.getBeanName())) {
                throw ex;
            }
            UserDetailsService uds = (UserDetailsService)this.bf.getBeanProvider(UserDetailsService.class).getIfUnique();
            if (uds == null) {
                throw new NoSuchBeanDefinitionException("org.springframework.security.authenticationManager", MISSING_BEAN_ERROR_MESSAGE);
            }
            DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
            provider.setUserDetailsService(uds);
            PasswordEncoder passwordEncoder = (PasswordEncoder)this.bf.getBeanProvider(PasswordEncoder.class).getIfUnique();
            if (passwordEncoder != null) {
                provider.setPasswordEncoder(passwordEncoder);
            }
            provider.afterPropertiesSet();
            ProviderManager manager = new ProviderManager(Arrays.asList(provider));
            if (this.observationRegistry.isNoop()) {
                return manager;
            }
            return new ObservationAuthenticationManager(this.observationRegistry, (AuthenticationManager)manager);
        }
    }

    public Class<? extends AuthenticationManager> getObjectType() {
        return ProviderManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.bf = beanFactory;
    }

    public void setObservationRegistry(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }
}

