/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.cifs.BaseCifsConnectionBuilder;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.cifs.telnet.CifsTelnetConnection;
import com.xebialabs.overthere.cifs.winrm.CifsWinRmConnection;
import com.xebialabs.overthere.cifs.winrs.CifsWinrsConnection;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;

@Protocol(name="cifs")
public class CifsConnectionBuilder
extends BaseCifsConnectionBuilder
implements OverthereConnectionBuilder {
    public static final String CIFS_PROTOCOL = "cifs";
    public static final String CIFS_PORT = "cifsPort";
    public static final int CIFS_PORT_DEFAULT = 445;
    private CifsConnection connection;

    public CifsConnectionBuilder(String type, ConnectionOptions options, AddressPortMapper mapper) {
        CifsConnectionType cifsConnectionType = options.getEnum("connectionType", CifsConnectionType.class);
        switch (cifsConnectionType) {
            case TELNET: {
                this.connection = new CifsTelnetConnection(type, options, mapper);
                break;
            }
            case WINRM_INTERNAL: {
                this.connection = new CifsWinRmConnection(type, options, mapper);
                break;
            }
            case WINRM_NATIVE: {
                this.connection = new CifsWinrsConnection(type, options, mapper);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CIFS connection type " + cifsConnectionType);
            }
        }
    }

    @Override
    public OverthereConnection connect() {
        this.connection.connect();
        return this.connection;
    }

    public String toString() {
        return this.connection.toString();
    }
}

