/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.PropertyBasedMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.property.access.internal.PropertyAccessStrategyBasicImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.StandardVirtualTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.embeddable.internal.AggregateEmbeddableFetchImpl;
import org.hibernate.sql.results.graph.embeddable.internal.AggregateEmbeddableResultImpl;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableFetchImpl;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultImpl;

public class EmbeddedAttributeMapping
extends AbstractSingularAttributeMapping
implements EmbeddableValuedFetchable,
Fetchable {
    private final NavigableRole navigableRole;
    private final String tableExpression;
    private final EmbeddableMappingType embeddableMappingType;
    private final PropertyAccess parentInjectionAttributePropertyAccess;
    private final boolean selectable;

    public EmbeddedAttributeMapping(String name, NavigableRole navigableRole, int stateArrayPosition, int fetchableIndex, String tableExpression, AttributeMetadata attributeMetadata, String parentInjectionAttributeName, FetchTiming mappedFetchTiming, FetchStyle mappedFetchStyle, EmbeddableMappingType embeddableMappingType, ManagedMappingType declaringType, PropertyAccess propertyAccess) {
        this(name, navigableRole, stateArrayPosition, fetchableIndex, tableExpression, attributeMetadata, EmbeddedAttributeMapping.getPropertyAccess(parentInjectionAttributeName, embeddableMappingType), mappedFetchTiming, mappedFetchStyle, embeddableMappingType, declaringType, propertyAccess);
    }

    public EmbeddedAttributeMapping(String name, NavigableRole navigableRole, int stateArrayPosition, int fetchableIndex, String tableExpression, AttributeMetadata attributeMetadata, PropertyAccess parentInjectionAttributePropertyAccess, FetchTiming mappedFetchTiming, FetchStyle mappedFetchStyle, EmbeddableMappingType embeddableMappingType, ManagedMappingType declaringType, PropertyAccess propertyAccess) {
        super(name, stateArrayPosition, fetchableIndex, attributeMetadata, mappedFetchTiming, mappedFetchStyle, declaringType, propertyAccess);
        this.navigableRole = navigableRole;
        this.parentInjectionAttributePropertyAccess = parentInjectionAttributePropertyAccess;
        this.tableExpression = tableExpression;
        this.embeddableMappingType = embeddableMappingType;
        this.selectable = this.getAttributeName().equals("_identifierMapper") ? false : attributeMetadata.isSelectable();
    }

    EmbeddedAttributeMapping(ManagedMappingType keyDeclaringType, TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, EmbeddableValuedModelPart inverseModelPart, EmbeddableMappingType embeddableTypeDescriptor, MappingModelCreationProcess creationProcess) {
        super(inverseModelPart.getFetchableName(), inverseModelPart.asAttributeMapping() != null ? inverseModelPart.asAttributeMapping().getStateArrayPosition() : -1, inverseModelPart.getFetchableKey(), inverseModelPart.asAttributeMapping() != null ? inverseModelPart.asAttributeMapping().getAttributeMetadata() : null, inverseModelPart.getMappedFetchOptions(), keyDeclaringType, inverseModelPart instanceof PropertyBasedMapping ? ((PropertyBasedMapping)((Object)inverseModelPart)).getPropertyAccess() : null);
        AttributeMapping attributeMapping;
        this.navigableRole = inverseModelPart.getNavigableRole().getParent().append(inverseModelPart.getFetchableName());
        this.tableExpression = selectableMappings.getSelectable(0).getContainingTableExpression();
        this.embeddableMappingType = embeddableTypeDescriptor.createInverseMappingType(this, declaringTableGroupProducer, selectableMappings, creationProcess);
        this.parentInjectionAttributePropertyAccess = null;
        this.selectable = this.getAttributeName().equals("_identifierMapper") ? false : ((attributeMapping = inverseModelPart.asAttributeMapping()) != null ? attributeMapping.isSelectable() : true);
    }

    @Override
    public EmbeddableMappingType getMappedType() {
        return this.getEmbeddableTypeDescriptor();
    }

    @Override
    public EmbeddableMappingType getEmbeddableTypeDescriptor() {
        return this.embeddableMappingType;
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public PropertyAccess getParentInjectionAttributePropertyAccess() {
        return this.parentInjectionAttributePropertyAccess;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        if (this.embeddableMappingType.shouldSelectAggregateMapping()) {
            return new AggregateEmbeddableResultImpl(navigablePath, this, resultVariable, creationState);
        }
        return new EmbeddableResultImpl(navigablePath, this, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.embeddableMappingType.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.embeddableMappingType.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        if (this.embeddableMappingType.shouldSelectAggregateMapping()) {
            return new AggregateEmbeddableFetchImpl(fetchablePath, this, fetchParent, fetchTiming, selected, creationState);
        }
        return new EmbeddableFetchImpl(fetchablePath, this, fetchParent, fetchTiming, selected, creationState);
    }

    @Override
    public SqlTuple toSqlExpression(TableGroup tableGroup, Clause clause, SqmToSqlAstConverter walker, SqlAstCreationState sqlAstCreationState) {
        if (this.embeddableMappingType.getAggregateMapping() != null) {
            SelectableMapping selection2 = this.embeddableMappingType.getAggregateMapping();
            NavigablePath navigablePath = tableGroup.getNavigablePath().append(this.getNavigableRole().getNavigableName());
            TableReference tableReference = tableGroup.resolveTableReference(navigablePath, this.getContainingTableExpression());
            return new SqlTuple(Collections.singletonList(sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(tableReference, selection2)), this);
        }
        ArrayList columnReferences = CollectionHelper.arrayList(this.embeddableMappingType.getJdbcTypeCount());
        NavigablePath navigablePath = tableGroup.getNavigablePath().append(this.getNavigableRole().getNavigableName());
        TableReference defaultTableReference = tableGroup.resolveTableReference(navigablePath, this, this.getContainingTableExpression());
        this.getEmbeddableTypeDescriptor().forEachSelectable((columnIndex, selection) -> {
            TableReference tableReference = this.getContainingTableExpression().equals(selection.getContainingTableExpression()) ? defaultTableReference : tableGroup.resolveTableReference(navigablePath, this, selection.getContainingTableExpression());
            Expression columnReference = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(tableReference, selection);
            columnReferences.add(columnReference.getColumnReference());
        });
        return new SqlTuple(columnReferences, this);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, @Nullable String explicitSourceAlias, @Nullable SqlAliasBase explicitSqlAliasBase, @Nullable SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, SqlAstCreationState creationState) {
        SqlAstJoinType joinType = Objects.requireNonNullElse(requestedJoinType, SqlAstJoinType.INNER);
        TableGroup tableGroup = this.createRootTableGroupJoin(navigablePath, lhs, explicitSourceAlias, explicitSqlAliasBase, requestedJoinType, fetched, null, creationState);
        return new TableGroupJoin(navigablePath, joinType, tableGroup);
    }

    @Override
    public TableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, @Nullable String explicitSourceAlias, @Nullable SqlAliasBase explicitSqlAliasBase, @Nullable SqlAstJoinType sqlAstJoinType, boolean fetched, @Nullable Consumer<Predicate> predicateConsumer, SqlAstCreationState creationState) {
        return new StandardVirtualTableGroup(navigablePath, this, lhs, fetched);
    }

    @Override
    public String getSqlAliasStem() {
        return this.getAttributeName();
    }

    public String toString() {
        return "EmbeddedAttributeMapping(" + this.navigableRole + ")@" + System.identityHashCode(this);
    }

    private static PropertyAccess getPropertyAccess(String parentInjectionAttributeName, EmbeddableMappingType embeddableMappingType) {
        PropertyAccess parentInjectionAttributePropertyAccess = parentInjectionAttributeName != null ? PropertyAccessStrategyBasicImpl.INSTANCE.buildPropertyAccess(embeddableMappingType.getMappedJavaType().getJavaTypeClass(), parentInjectionAttributeName, true) : null;
        return parentInjectionAttributePropertyAccess;
    }

    @Override
    public EmbeddedAttributeMapping asEmbeddedAttributeMapping() {
        return this;
    }

    @Override
    public boolean isEmbeddedAttributeMapping() {
        return true;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public boolean containsTableReference(String tableExpression) {
        ManagedMappingType declaringType = this.getDeclaringType();
        TableGroupProducer producer = declaringType instanceof TableGroupProducer ? (TableGroupProducer)((Object)declaringType) : ((EmbeddableMappingType)declaringType).getEmbeddedValueMapping();
        return producer.containsTableReference(tableExpression);
    }

    @Override
    public int compare(Object value1, Object value2) {
        return this.embeddableMappingType.compare(value1, value2);
    }
}

