/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayToStringFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class H2ArrayToStringFunction
extends ArrayToStringFunction {
    private final int maximumArraySize;

    public H2ArrayToStringFunction(int maximumArraySize, TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
        this.maximumArraySize = maximumArraySize;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression separatorExpression = (Expression)sqlAstArguments.get(1);
        sqlAppender.append("case when ");
        arrayExpression.accept(walker);
        sqlAppender.append(" is not null then coalesce((select listagg(array_get(");
        arrayExpression.accept(walker);
        sqlAppender.append(",i.idx),");
        separatorExpression.accept(walker);
        sqlAppender.append(") within group (order by i.idx) from system_range(1,");
        sqlAppender.append(Integer.toString(this.maximumArraySize));
        sqlAppender.append(") i(idx) where i.idx<=coalesce(cardinality(");
        arrayExpression.accept(walker);
        sqlAppender.append("),0)),'') end");
    }
}

