/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class NextSequenceNode
extends ValueNode {
    private TableName sequenceName;
    private SequenceDescriptor sequenceDescriptor;

    NextSequenceNode(TableName tableName, ContextManager contextManager) {
        super(contextManager);
        this.sequenceName = tableName;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list, boolean bl) throws StandardException {
        if (this.sequenceDescriptor != null) {
            return this;
        }
        CompilerContext compilerContext = this.getCompilerContext();
        if ((compilerContext.getReliability() & 0x4000) != 0) {
            throw StandardException.newException("42XAH", new Object[0]);
        }
        this.sequenceName.bind();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.sequenceName.getSchemaName());
        this.sequenceDescriptor = this.getDataDictionary().getSequenceDescriptor(schemaDescriptor, this.sequenceName.getTableName());
        if (this.sequenceDescriptor == null) {
            throw StandardException.newException("42X94", "SEQUENCE", this.sequenceName.getFullTableName());
        }
        if (schemaDescriptor.isSystemSchema()) {
            throw StandardException.newException("42XAR", new Object[0]);
        }
        this.setType(this.sequenceDescriptor.getDataType());
        if (compilerContext.isReferenced(this.sequenceDescriptor)) {
            throw StandardException.newException("42XAI", this.sequenceName.getFullTableName());
        }
        compilerContext.addReferencedSequence(this.sequenceDescriptor);
        NextSequenceNode nextSequenceNode = this;
        this.getCompilerContext().createDependency(this.sequenceDescriptor);
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredUsagePriv(this.sequenceDescriptor);
        }
        return nextSequenceNode;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        String string = this.sequenceDescriptor.getUUID().toString();
        int n = this.sequenceDescriptor.getDataType().getNull().getTypeFormatId();
        methodBuilder.pushThis();
        methodBuilder.push(string);
        methodBuilder.push(n);
        methodBuilder.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getCurrentValueAndAdvance", "org.apache.derby.iapi.types.NumberDataValue", 2);
    }

    void generateConstant(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        switch (this.getTypeServices().getJDBCTypeId()) {
            case 4: {
                methodBuilder.push(1);
                break;
            }
        }
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        return false;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.sequenceName != null) {
            this.sequenceName = (TableName)this.sequenceName.accept(visitor);
        }
    }
}

