/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractBatchEntitySelectFetchInitializer
implements EntityInitializer {
    protected final FetchParentAccess parentAccess;
    private final NavigablePath navigablePath;
    private final FetchParentAccess owningParent;
    private final EntityMappingType ownedModelPartDeclaringType;
    private final boolean isPartOfKey;
    protected final EntityPersister concreteDescriptor;
    protected final DomainResultAssembler<?> identifierAssembler;
    protected final ToOneAttributeMapping referencedModelPart;
    protected final EntityInitializer firstEntityInitializer;
    protected boolean parentShallowCached;
    protected Object initializedEntityInstance;
    protected EntityKey entityKey;
    protected State state = State.UNINITIALIZED;

    public AbstractBatchEntitySelectFetchInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping referencedModelPart, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler<?> identifierAssembler) {
        this.parentAccess = parentAccess;
        this.referencedModelPart = referencedModelPart;
        this.navigablePath = fetchedNavigable;
        this.isPartOfKey = Initializer.isPartOfKey(fetchedNavigable, parentAccess);
        this.owningParent = FetchParentAccess.determineOwningParent(parentAccess);
        this.ownedModelPartDeclaringType = FetchParentAccess.determineOwnedModelPartDeclaringType(referencedModelPart, parentAccess, this.owningParent);
        this.concreteDescriptor = concreteDescriptor;
        this.identifierAssembler = identifierAssembler;
        this.firstEntityInitializer = parentAccess.findFirstEntityInitializer();
        assert (this.firstEntityInitializer != null) : "This initializer requires parentAccess.findFirstEntityInitializer() to not be null";
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public boolean isPartOfKey() {
        return this.isPartOfKey;
    }

    @Override
    public boolean isResultInitializer() {
        return false;
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
    }

    protected abstract void registerResolutionListener();

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.state != State.UNINITIALIZED) {
            return;
        }
        if (this.parentShallowCached || this.shouldSkipInitializer(rowProcessingState)) {
            this.state = State.MISSING;
            return;
        }
        Object entityIdentifier = this.identifierAssembler.assemble(rowProcessingState);
        if (entityIdentifier == null) {
            this.state = State.MISSING;
        } else {
            this.entityKey = new EntityKey(entityIdentifier, this.concreteDescriptor);
            this.state = State.KEY_RESOLVED;
        }
    }

    protected Object getExistingInitializedInstance(RowProcessingState rowProcessingState) {
        assert (this.entityKey != null);
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        EntityHolder holder = persistenceContext.getEntityHolder(this.entityKey);
        if (holder != null && holder.getEntity() != null && holder.isEventuallyInitialized()) {
            return holder.getEntity();
        }
        this.registerResolutionListener();
        return null;
    }

    protected void registerToBatchFetchQueue(RowProcessingState rowProcessingState) {
        assert (this.entityKey != null);
        rowProcessingState.getSession().getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(this.entityKey);
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, RowProcessingState rowProcessingState) {
        AttributeMapping attributeMapping = this.getInitializedPart().asAttributeMapping();
        Object instance = attributeMapping != null ? attributeMapping.getValue(parentInstance) : parentInstance;
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(instance);
        if (lazyInitializer != null && lazyInitializer.isUninitialized()) {
            this.entityKey = new EntityKey(lazyInitializer.getIdentifier(), this.concreteDescriptor);
            this.registerToBatchFetchQueue(rowProcessingState);
        }
        this.state = State.INITIALIZED;
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.initializedEntityInstance = null;
        this.entityKey = null;
        this.state = State.UNINITIALIZED;
    }

    @Override
    public void markShallowCached() {
        this.parentShallowCached = true;
    }

    @Override
    public void endLoading(ExecutionContext executionContext) {
        this.parentShallowCached = false;
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.initializedEntityInstance;
    }

    protected static Object loadInstance(EntityKey entityKey, ToOneAttributeMapping referencedModelPart, SharedSessionContractImplementor session) {
        return session.internalLoad(entityKey.getEntityName(), entityKey.getIdentifier(), true, referencedModelPart.isInternalLoadNullable());
    }

    protected AttributeMapping getParentEntityAttribute(String attributeName) {
        AttributeMapping parentAttribute = this.firstEntityInitializer.getConcreteDescriptor().findAttributeMapping(attributeName);
        if (parentAttribute != null && parentAttribute.getDeclaringType() == this.referencedModelPart.getDeclaringType().findContainingEntityMapping()) {
            return parentAttribute;
        }
        return null;
    }

    @Override
    public FetchParentAccess getFetchParentAccess() {
        return this.parentAccess;
    }

    @Override
    public @Nullable FetchParentAccess getOwningParent() {
        return this.owningParent;
    }

    @Override
    public @Nullable EntityMappingType getOwnedModelPartDeclaringType() {
        return this.ownedModelPartDeclaringType;
    }

    @Override
    public EntityPersister getConcreteDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public EntityKey getEntityKey() {
        throw new UnsupportedOperationException("This should never happen, because this initializer has not child initializers");
    }

    @Override
    public Object getParentKey() {
        throw new UnsupportedOperationException("This should never happen, because this initializer has not child initializers");
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        throw new UnsupportedOperationException("This should never happen, because this initializer has not child initializers");
    }

    protected static enum State {
        UNINITIALIZED,
        MISSING,
        KEY_RESOLVED,
        INITIALIZED;

    }
}

