/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import ai.digital.configuration.central.deploy.ClientProperties;
import ai.digital.configuration.central.deploy.WebSocketsProperties;
import com.xebialabs.deployit.core.rest.converters.CiIdsMessageConverter;
import com.xebialabs.deployit.core.rest.json.CiRefsJsonWriter;
import com.xebialabs.deployit.core.rest.websockets.ServletContextAwareJettyRequestUpgradeStrategy;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@Configuration
@EnableWebSocketMessageBroker
@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001\u0002\b\u0010\u0001qA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003c\u0011!\t\bA!A!\u0002\u0013\u0011\b\"\u0002<\u0001\t\u00039\b\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011!\ti\u0002\u0001Q\u0001\n\u0005E\u0001bBA\u0010\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003w\u0001A\u0011AA\u001f\u0011\u001d\ti\u0006\u0001C!\u0003?Bq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002v\u0001!\t%a\u001e\u00039]+'mU8dW\u0016$X*Z:tC\u001e,'I]8lKJ\u001cuN\u001c4jO*\u0011\u0001#E\u0001\u000bo\u0016\u00147o\\2lKR\u001c(B\u0001\n\u0014\u0003\u0011\u0011Xm\u001d;\u000b\u0005Q)\u0012\u0001B2pe\u0016T!AF\f\u0002\u0011\u0011,\u0007\u000f\\8zSRT!\u0001G\r\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u000e\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001iR\u0005\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005!A.\u00198h\u0015\u0005\u0011\u0013\u0001\u00026bm\u0006L!\u0001J\u0010\u0003\r=\u0013'.Z2u!\t13'D\u0001(\u0015\tA\u0013&\u0001\u0006b]:|G/\u0019;j_:T!AK\u0016\u0002\r\r|gNZ5h\u0015\taS&\u0001\u0004t_\u000e\\W\r\u001e\u0006\u0003]=\n1a^3c\u0015\t\u0001\u0014'A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0011\u0014aA8sO&\u0011Ag\n\u0002!/\u0016\u00147k\\2lKRlUm]:bO\u0016\u0014%o\\6fe\u000e{gNZ5hkJ,'/\u0001\tdSJ+gm\u001d&t_:<&/\u001b;feB\u0011qGO\u0007\u0002q)\u0011\u0011(E\u0001\u0005UN|g.\u0003\u0002<q\t\u00012)\u001b*fMNT5o\u001c8Xe&$XM\u001d\u0015\u0003\u0003u\u0002\"A\u0010#\u000e\u0003}R!\u0001\u000b!\u000b\u0005\u0005\u0013\u0015a\u00024bGR|'/\u001f\u0006\u0003\u0007>\nQAY3b]NL!!R \u0003\u0013\u0005+Ho\\<je\u0016$\u0017!\u0004;bg.\u001c6\r[3ek2,'\u000f\u0005\u0002I\u00176\t\u0011J\u0003\u0002K_\u0005Q1o\u00195fIVd\u0017N\\4\n\u00051K%!\u0004+bg.\u001c6\r[3ek2,'\u000f\u000b\u0002\u0003{!\"!a\u0014*T!\tq\u0004+\u0003\u0002R\u007f\tI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002)\u0006\u0019r/\u001a2t_\u000e\\W\r^:TG\",G-\u001e7fe\u0006yQo]3s\u0013:$XM]2faR|'\u000f\u0005\u0002X96\t\u0001L\u0003\u0002Z5\u000691/\u001e9q_J$(BA.0\u0003%iWm]:bO&tw-\u0003\u0002^1\n\u00112\t[1o]\u0016d\u0017J\u001c;fe\u000e,\u0007\u000f^8sQ\t\u0019Q\b\u000b\u0003\u0004\u001fJ\u0003\u0017%A+\u0002/],'mU8dW\u0016$8oQ8oM&<WO]1uS>t\u0007CA2o\u001b\u0005!'BA3g\u0003\u0019!W\r\u001d7ps*\u0011q\r[\u0001\bG\u0016tGO]1m\u0015\tI'.A\u0007d_:4\u0017nZ;sCRLwN\u001c\u0006\u0003W2\fq\u0001Z5hSR\fGNC\u0001n\u0003\t\t\u0017.\u0003\u0002pI\n!r+\u001a2T_\u000e\\W\r^:Qe>\u0004XM\u001d;jKND#\u0001B\u001f\u0002'\rd\u0017.\u001a8u\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005\r\u001c\u0018B\u0001;e\u0005A\u0019E.[3oiB\u0013x\u000e]3si&,7\u000f\u000b\u0002\u0006{\u00051A(\u001b8jiz\"\u0002\u0002\u001f>}\u007f\u0006\u0015\u0011\u0011\u0002\t\u0003s\u0002i\u0011a\u0004\u0005\u0006k\u0019\u0001\rA\u000e\u0015\u0003uvBQA\u0012\u0004A\u0002\u001dC#\u0001`\u001f)\tq|%k\u0015\u0005\u0006+\u001a\u0001\rA\u0016\u0015\u0003\u007fvBCa`(SA\")\u0011M\u0002a\u0001E\"\u001a\u0011QA\u001f\t\u000bE4\u0001\u0019\u0001:)\u0007\u0005%Q(A\bj]B,HOQ;gM\u0016\u00148+\u001b>f+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\t\t9\"A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u001c\u0005U!aA%oi\u0006\u0001\u0012N\u001c9vi\n+hMZ3s'&TX\rI\u0001\u0017G>tg-[4ve\u0016lUm]:bO\u0016\u0014%o\\6feR!\u00111EA\u0015!\u0011\t\u0019\"!\n\n\t\u0005\u001d\u0012Q\u0003\u0002\u0005+:LG\u000fC\u0004\u0002,%\u0001\r!!\f\u0002\u0011I,w-[:uef\u0004B!a\f\u000285\u0011\u0011\u0011\u0007\u0006\u0004U\u0005M\"bAA\u001b5\u0006!1/[7q\u0013\u0011\tI$!\r\u0003+5+7o]1hK\n\u0013xn[3s%\u0016<\u0017n\u001d;ss\u0006\u0001\u0002.\u00198eg\"\f7.\u001a%b]\u0012dWM\u001d\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002J5\u0011\u00111\t\u0006\u00043\u0006\u0015#bAA$W\u000511/\u001a:wKJLA!a\u0013\u0002D\t9B)\u001a4bk2$\b*\u00198eg\"\f7.\u001a%b]\u0012dWM\u001d\u0015\u0004\u0015\u0005=\u0003\u0003BA)\u00033j!!a\u0015\u000b\u0007!\n)FC\u0002\u0002X=\nqaY8oi\u0016DH/\u0003\u0003\u0002\\\u0005M#\u0001\u0002\"fC:\faC]3hSN$XM]*u_6\u0004XI\u001c3q_&tGo\u001d\u000b\u0005\u0003G\t\t\u0007C\u0004\u0002,-\u0001\r!a\u0019\u0011\u0007\u0019\n)'C\u0002\u0002h\u001d\u0012Qc\u0015;p[B,e\u000e\u001a9pS:$(+Z4jgR\u0014\u00180A\u000fd_:4\u0017nZ;sK\u000ec\u0017.\u001a8u\u0013:\u0014w.\u001e8e\u0007\"\fgN\\3m)\u0011\t\u0019#!\u001c\t\u000f\u0005-B\u00021\u0001\u0002pA!\u0011qFA9\u0013\u0011\t\u0019(!\r\u0003'\rC\u0017M\u001c8fYJ+w-[:ue\u0006$\u0018n\u001c8\u00025\r|gNZ5hkJ,W*Z:tC\u001e,7i\u001c8wKJ$XM]:\u0015\t\u0005e\u0014q\u0010\t\u0005\u0003'\tY(\u0003\u0003\u0002~\u0005U!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0003k\u0001\u0019AAB\u0003EiWm]:bO\u0016\u001cuN\u001c<feR,'o\u001d\t\u0007\u0003\u000b\u000bY)a$\u000e\u0005\u0005\u001d%bAAEC\u0005!Q\u000f^5m\u0013\u0011\ti)a\"\u0003\t1K7\u000f\u001e\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011Q\u0013.\u0002\u0013\r|gN^3si\u0016\u0014\u0018\u0002BAM\u0003'\u0013\u0001#T3tg\u0006<WmQ8om\u0016\u0014H/\u001a:)\u0007\u0001\ti\n\u0005\u0003\u0002R\u0005}\u0015\u0002BAQ\u0003'\u0012QbQ8oM&<WO]1uS>t\u0007f\u0001\u0001\u0002&B\u0019a%a*\n\u0007\u0005%vE\u0001\u000fF]\u0006\u0014G.Z,fEN{7m[3u\u001b\u0016\u001c8/Y4f\u0005J|7.\u001a:")
public class WebSocketMessageBrokerConfig
implements WebSocketMessageBrokerConfigurer {
    @Autowired
    private final CiRefsJsonWriter ciRefsJsonWriter;
    @Autowired
    @Qualifier(value="websocketsScheduler")
    private final TaskScheduler taskScheduler;
    @Autowired
    @Qualifier(value="userInterceptor")
    private final ChannelInterceptor userInterceptor;
    @Autowired
    private final ClientProperties clientConfiguration;
    private final int inputBufferSize;

    public void configureWebSocketTransport(WebSocketTransportRegistration registry) {
        super.configureWebSocketTransport(registry);
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        super.configureClientOutboundChannel(registration);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        super.addArgumentResolvers(argumentResolvers);
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        super.addReturnValueHandlers(returnValueHandlers);
    }

    @Nullable
    public Integer getPhase() {
        return super.getPhase();
    }

    private int inputBufferSize() {
        return this.inputBufferSize;
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.setApplicationDestinationPrefixes(new String[]{"/app"});
        registry.enableSimpleBroker(new String[]{"/topic"}).setTaskScheduler(this.taskScheduler);
    }

    @Bean
    public DefaultHandshakeHandler handshakeHandler() {
        long idleTimeout = TimeUnit.MINUTES.toMillis(this.clientConfiguration.getSession().getTimeoutMinute());
        return new DefaultHandshakeHandler((RequestUpgradeStrategy)new ServletContextAwareJettyRequestUpgradeStrategy(Predef$.MODULE$.int2Integer(this.inputBufferSize()), idleTimeout));
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/ws"}).setAllowedOriginPatterns(new String[]{"*"}).setHandshakeHandler((HandshakeHandler)this.handshakeHandler()).withSockJS();
    }

    public void configureClientInboundChannel(ChannelRegistration registry) {
        registry.interceptors(new ChannelInterceptor[]{this.userInterceptor});
    }

    public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        messageConverters.add((MessageConverter)new CiIdsMessageConverter(this.ciRefsJsonWriter));
        return true;
    }

    public WebSocketMessageBrokerConfig(@Autowired CiRefsJsonWriter ciRefsJsonWriter, @Autowired @Qualifier(value="websocketsScheduler") TaskScheduler taskScheduler, @Autowired @Qualifier(value="userInterceptor") ChannelInterceptor userInterceptor, @Autowired WebSocketsProperties webSocketsConfiguration, @Autowired ClientProperties clientConfiguration) {
        this.ciRefsJsonWriter = ciRefsJsonWriter;
        this.taskScheduler = taskScheduler;
        this.userInterceptor = userInterceptor;
        this.clientConfiguration = clientConfiguration;
        this.inputBufferSize = webSocketsConfiguration.messageBroker().inputBufferSize();
    }
}

