/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import javax.management.MBeanServer;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Util;

public class LargeState
implements Receiver {
    JChannel channel;
    byte[] state = null;
    boolean rc = false;
    String props;
    long start;
    long stop;
    boolean provider = true;
    boolean provider_fails = false;
    boolean requester_fails = false;
    int size = 100000;
    int total_received = 0;
    long delay = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean provider, int size, String props, boolean provider_fails, boolean requester_fails, long delay, String name) throws Exception {
        this.provider = provider;
        this.provider_fails = provider_fails;
        this.requester_fails = requester_fails;
        this.delay = delay;
        this.channel = new JChannel(props);
        this.channel.setReceiver(this);
        if (name != null) {
            this.channel.setName(name);
        }
        this.channel.connect("TestChannel");
        MBeanServer server = Util.getMBeanServer();
        if (server == null) {
            throw new Exception("No MBeanServers found;\nLargeState needs to be run with an MBeanServer present, or inside JDK 5");
        }
        JmxConfigurator.registerChannel(this.channel, server, "jgroups", this.channel.getClusterName(), true);
        System.out.println("-- connected to channel");
        if (provider) {
            this.size = size;
            System.out.println("Waiting for other members to join and fetch large state");
            while (true) {
                Util.sleep(10000L);
            }
        }
        this.start = System.currentTimeMillis();
        try {
            this.channel.getState(null, 0L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            Util.close((Closeable)this.channel);
        }
    }

    static byte[] createLargeState(int size) {
        return new byte[size];
    }

    @Override
    public void receive(Message msg) {
        System.out.println("-- received msg " + String.valueOf(msg.getObject()) + " from " + String.valueOf(msg.getSrc()));
    }

    @Override
    public void viewAccepted(View new_view) {
        if (this.provider) {
            System.out.println("-- view: " + String.valueOf(new_view));
        }
    }

    @Override
    public void setState(InputStream istream) throws Exception {
        byte[] buf;
        this.total_received = 0;
        int received = 0;
        while ((received = istream.read(buf = new byte[10000])) >= 0) {
            if (this.delay > 0L) {
                Util.sleep(this.delay);
            }
            this.total_received += received;
            if (!this.requester_fails) continue;
            throw new Exception("booom - requester failed");
        }
        this.stop = System.currentTimeMillis();
        System.out.println("<-- received " + Util.printBytes(this.total_received) + " in " + (this.stop - this.start) + "ms");
    }

    @Override
    public void getState(OutputStream ostream) throws Exception {
        byte[] buf;
        int frag_size = this.size / 10;
        long bytes = 0L;
        for (int i = 0; i < 10; ++i) {
            buf = new byte[frag_size];
            ostream.write(buf);
            bytes += (long)buf.length;
            if (this.provider_fails) {
                throw new Exception("booom - provider failed");
            }
            if (this.delay <= 0L) continue;
            Util.sleep(this.delay);
        }
        int remaining = this.size - 10 * frag_size;
        if (remaining > 0) {
            buf = new byte[remaining];
            ostream.write(buf);
            bytes += (long)buf.length;
        }
        System.out.println("--> wrote " + Util.printBytes(bytes));
    }

    public static void main(String[] args) {
        boolean provider = false;
        boolean provider_fails = false;
        boolean requester_fails = false;
        int size = 0x100000;
        String props = null;
        long delay = 0L;
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                LargeState.help();
                return;
            }
            if ("-provider".equals(args[i])) {
                provider = true;
                continue;
            }
            if ("-provider_fails".equals(args[i])) {
                provider_fails = true;
                continue;
            }
            if ("-requester_fails".equals(args[i])) {
                requester_fails = true;
                continue;
            }
            if ("-size".equals(args[i])) {
                size = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-delay".equals(args[i])) {
                delay = Long.parseLong(args[++i]);
                continue;
            }
            if ("-name".equals(args[i])) {
                name = args[++i];
                continue;
            }
            LargeState.help();
            return;
        }
        try {
            new LargeState().start(provider, size, props, provider_fails, requester_fails, delay, name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void help() {
        System.out.println("LargeState [-help] [-size <size of state in bytes] [-provider] [-name name] [-props <properties>] [-provider_fails] [-requester_fails] [-delay <ms>]");
    }
}

