/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded.functions;

import java.util.Objects;
import java.util.function.Supplier;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.MutableEntry;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.jcache.Expiration;
import org.infinispan.jcache.embedded.Durations;

class MutableEntryWrapper<K, V>
implements MutableEntry<K, V> {
    private final EntryView.ReadWriteEntryView<K, V> view;
    private final Supplier<V> copySupplier;
    private final boolean existsBefore;
    private final ExpiryPolicy expiryPolicy;
    private V valueCopy;
    private boolean isRead;
    private boolean isModified;

    MutableEntryWrapper(EntryView.ReadWriteEntryView<K, V> view, Supplier<V> copySupplier, boolean existsBefore, ExpiryPolicy expiryPolicy) {
        this.view = view;
        this.copySupplier = copySupplier;
        this.existsBefore = existsBefore;
        this.expiryPolicy = expiryPolicy;
    }

    public boolean exists() {
        if (!this.isRead && !this.isModified) {
            this.isRead = true;
            this.valueCopy = this.copySupplier.get();
        }
        return this.valueCopy != null;
    }

    public void remove() {
        if (this.isRead) {
            this.view.remove();
        } else {
            this.view.set(null, new MetaParam.Writable[0]);
        }
        this.valueCopy = null;
        this.isRead = true;
        this.isModified = true;
    }

    public K getKey() {
        return (K)this.view.key();
    }

    public V getValue() {
        if (!this.isRead && !this.isModified) {
            this.isRead = true;
            this.valueCopy = this.copySupplier.get();
        }
        return this.valueCopy;
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)ReflectionUtil.unwrap((Object)this, clazz);
    }

    public void setValue(V value) {
        Objects.requireNonNull(value, "Value must not be null");
        this.isModified = true;
        this.valueCopy = value;
        Durations.setWithTtl(this.view, value, this.expiryPolicy, this.existsBefore ? Expiration.Operation.UPDATE : Expiration.Operation.CREATION);
    }

    boolean isRead() {
        return this.isRead;
    }

    boolean isModified() {
        return this.isModified;
    }
}

