/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public abstract class SessionContinuationMessage
extends PacketImpl {
    public static final int SESSION_CONTINUATION_BASE_SIZE = 18;
    protected byte[] body;
    protected boolean continues;

    public SessionContinuationMessage(byte type, byte[] body, boolean continues) {
        super(type);
        this.body = body;
        this.continues = continues;
    }

    public SessionContinuationMessage(byte type) {
        super(type);
    }

    public byte[] getBody() {
        if (this.size <= 0) {
            return new byte[0];
        }
        return this.body;
    }

    public boolean isContinues() {
        return this.continues;
    }

    @Override
    public int expectedEncodeSize() {
        return 18 + (this.body == null ? 0 : this.body.length);
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.body.length);
        buffer.writeBytes(this.body);
        buffer.writeBoolean(this.continues);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        int size = buffer.readInt();
        this.body = new byte[size];
        buffer.readBytes(this.body);
        this.continues = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.body);
        result = 31 * result + (this.continues ? 1231 : 1237);
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuffer buff = new StringBuffer(super.getPacketString());
        buff.append(", body=" + Arrays.toString(this.body));
        buff.append(", continues=" + this.continues);
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionContinuationMessage)) {
            return false;
        }
        SessionContinuationMessage other = (SessionContinuationMessage)obj;
        if (!Arrays.equals(this.body, other.body)) {
            return false;
        }
        return this.continues == other.continues;
    }
}

