/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.policy;

import java.util.function.Predicate;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.context.RetryContextSupport;
import org.springframework.util.Assert;

public class PredicateRetryPolicy
implements RetryPolicy {
    private final Predicate<Throwable> predicate;

    public PredicateRetryPolicy(Predicate<Throwable> predicate) {
        Assert.notNull(predicate, (String)"'predicate' must not be null");
        this.predicate = predicate;
    }

    @Override
    public boolean canRetry(RetryContext context) {
        Throwable t = context.getLastThrowable();
        return t == null || this.predicate.test(t);
    }

    @Override
    public void close(RetryContext status) {
    }

    @Override
    public void registerThrowable(RetryContext context, Throwable throwable) {
        ((RetryContextSupport)context).registerThrowable(throwable);
    }

    @Override
    public RetryContext open(RetryContext parent) {
        return new RetryContextSupport(parent);
    }
}

