/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.endpoint;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.awscore.endpoint.DualstackEnabledProvider;
import software.amazon.awssdk.awscore.endpoint.FipsEnabledProvider;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.regions.EndpointTag;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServiceMetadataAdvancedOption;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.OptionalUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.internal.SystemSettingUtils;

@SdkProtectedApi
public final class AwsClientEndpointProvider
implements ClientEndpointProvider {
    private static final Logger log = Logger.loggerFor(AwsClientEndpointProvider.class);
    private static final String GLOBAL_ENDPOINT_OVERRIDE_ENVIRONMENT_VARIABLE = "AWS_ENDPOINT_URL";
    private static final String GLOBAL_ENDPOINT_OVERRIDE_SYSTEM_PROPERTY = "aws.endpointUrl";
    private final Lazy<ClientEndpoint> clientEndpoint = new Lazy(() -> this.resolveClientEndpoint(new Builder(builder)));

    private AwsClientEndpointProvider(Builder builder) {
    }

    public static Builder builder() {
        return new Builder();
    }

    public URI clientEndpoint() {
        return ((ClientEndpoint)this.clientEndpoint.getValue()).clientEndpoint;
    }

    public boolean isEndpointOverridden() {
        return ((ClientEndpoint)this.clientEndpoint.getValue()).isEndpointOverridden;
    }

    private ClientEndpoint resolveClientEndpoint(Builder builder) {
        return (ClientEndpoint)OptionalUtils.firstPresent(this.clientEndpointFromClientOverride(builder), (Supplier[])new Supplier[]{() -> this.clientEndpointFromEnvironment(builder), () -> this.clientEndpointFromServiceMetadata(builder)}).orElseThrow(AwsClientEndpointProvider::failToLoadEndpointException);
    }

    private static SdkClientException failToLoadEndpointException() {
        return SdkClientException.create((String)("Unable to determine the default client endpoint. Enable TRACE logging on " + AwsClientEndpointProvider.class.getName() + " for more information."));
    }

    private Optional<ClientEndpoint> clientEndpointFromClientOverride(Builder builder) {
        Optional<ClientEndpoint> result = Optional.ofNullable(builder.clientEndpointOverride).map(uri -> new ClientEndpoint((URI)uri, true));
        result.ifPresent(e -> log.trace(() -> "Client was configured with endpoint override: " + ((ClientEndpoint)e).clientEndpoint));
        return result;
    }

    private Optional<ClientEndpoint> clientEndpointFromEnvironment(Builder builder) {
        if (builder.serviceEndpointOverrideEnvironmentVariable == null || builder.serviceEndpointOverrideSystemProperty == null || builder.serviceProfileProperty == null) {
            Validate.isTrue((builder.serviceEndpointOverrideEnvironmentVariable == null && builder.serviceEndpointOverrideSystemProperty == null && builder.serviceProfileProperty == null ? 1 : 0) != 0, (String)"If any of the service endpoint override environment variable, system property or profile property are configured, they must all be configured.", (Object[])new Object[0]);
            log.trace(() -> "Environment was not checked for client endpoint.");
            return Optional.empty();
        }
        return OptionalUtils.firstPresent(this.systemProperty(builder.serviceEndpointOverrideSystemProperty), (Supplier[])new Supplier[]{() -> this.systemProperty(GLOBAL_ENDPOINT_OVERRIDE_SYSTEM_PROPERTY), () -> this.environmentVariable(builder.serviceEndpointOverrideEnvironmentVariable), () -> this.environmentVariable(GLOBAL_ENDPOINT_OVERRIDE_ENVIRONMENT_VARIABLE), () -> this.profileProperty(builder, builder.serviceProfileProperty + "." + "endpoint_url"), () -> this.profileProperty(builder, "endpoint_url")}).map(uri -> new ClientEndpoint((URI)uri, true));
    }

    private Optional<URI> systemProperty(String systemProperty) {
        return this.createUri("system property " + systemProperty, Optional.ofNullable(System.getProperty(systemProperty)));
    }

    private Optional<URI> environmentVariable(String environmentVariable) {
        return this.createUri("environment variable " + environmentVariable, SystemSettingUtils.resolveEnvironmentVariable((String)environmentVariable));
    }

    private Optional<URI> profileProperty(Builder builder, String profileProperty) {
        this.initializeProfileFileDefaults(builder);
        return this.createUri("profile property " + profileProperty, Optional.ofNullable((ProfileFile)builder.profileFile.get()).flatMap(pf -> pf.profile(builder.profileName)).flatMap(p -> p.property(profileProperty)));
    }

    private Optional<ClientEndpoint> clientEndpointFromServiceMetadata(Builder builder) {
        if (builder.serviceEndpointPrefix == null || builder.region == null || builder.protocol == null) {
            Validate.isTrue((builder.serviceEndpointPrefix == null && builder.region == null && builder.protocol == null ? 1 : 0) != 0, (String)"If any of the service endpoint prefix, region or protocol are configured, they must all be configured.", (Object[])new Object[0]);
            log.trace(() -> "Service metadata was not checked for client endpoint.");
            return Optional.empty();
        }
        Validate.paramNotNull((Object)builder.serviceEndpointPrefix, (String)"serviceName");
        Validate.paramNotNull((Object)builder.region, (String)"region");
        Validate.paramNotNull((Object)builder.protocol, (String)"protocol");
        this.initializeProfileFileDefaults(builder);
        if (builder.dualstackEnabled == null) {
            builder.dualstackEnabled = DualstackEnabledProvider.builder().profileFile(builder.profileFile).profileName(builder.profileName).build().isDualstackEnabled().orElse(false);
        }
        if (builder.fipsEnabled == null) {
            builder.fipsEnabled = FipsEnabledProvider.builder().profileFile(builder.profileFile).profileName(builder.profileName).build().isFipsEnabled().orElse(false);
        }
        ArrayList<EndpointTag> endpointTags = new ArrayList<EndpointTag>();
        if (builder.dualstackEnabled.booleanValue()) {
            endpointTags.add(EndpointTag.DUALSTACK);
        }
        if (builder.fipsEnabled.booleanValue()) {
            endpointTags.add(EndpointTag.FIPS);
        }
        ServiceMetadata serviceMetadata = ServiceMetadata.of((String)builder.serviceEndpointPrefix).reconfigure(c -> c.profileFile(builder.profileFile).profileName(builder.profileName).advancedOptions(builder.advancedOptions));
        URI endpointWithoutProtocol = serviceMetadata.endpointFor(ServiceEndpointKey.builder().region(builder.region).tags(endpointTags).build());
        URI endpoint = URI.create(builder.protocol + "://" + endpointWithoutProtocol);
        if (endpoint.getHost() == null) {
            String error = "Configured region (" + builder.region + ") and tags (" + endpointTags + ") resulted in an invalid URI: " + endpoint + ". This is usually caused by an invalid region configuration.";
            List exampleRegions = serviceMetadata.regions();
            if (!exampleRegions.isEmpty()) {
                error = error + " Valid regions: " + exampleRegions;
            }
            throw SdkClientException.create((String)error);
        }
        log.trace(() -> "Client endpoint was loaded from service metadata, but this endpoint will likely be overridden at the request-level by the endpoint resolver: " + endpoint);
        return Optional.of(new ClientEndpoint(endpoint, false));
    }

    private Optional<URI> createUri(String source, Optional<String> uri) {
        return uri.map(u -> {
            try {
                URI parsedUri = new URI((String)uri.get());
                log.trace(() -> "Client endpoint was loaded from the " + source + ": " + parsedUri);
                return parsedUri;
            }
            catch (URISyntaxException e) {
                throw SdkClientException.create((String)("An invalid URI was configured in " + source), (Throwable)e);
            }
        });
    }

    private void initializeProfileFileDefaults(Builder builder) {
        if (builder.profileFile == null) {
            builder.profileFile = () -> ((Lazy)new Lazy(ProfileFile::defaultProfileFile)).getValue();
        }
        if (builder.profileName == null) {
            builder.profileName = ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow();
        }
    }

    public static final class Builder {
        private URI clientEndpointOverride;
        private String serviceEndpointPrefix;
        private String protocol;
        private Region region;
        private Supplier<ProfileFile> profileFile;
        private String profileName;
        private final Map<ServiceMetadataAdvancedOption<?>, Object> advancedOptions = new HashMap();
        private Boolean dualstackEnabled;
        private Boolean fipsEnabled;
        private String serviceEndpointOverrideEnvironmentVariable;
        private String serviceEndpointOverrideSystemProperty;
        private String serviceProfileProperty;

        private Builder() {
        }

        private Builder(Builder src) {
            this.clientEndpointOverride = src.clientEndpointOverride;
            this.serviceEndpointPrefix = src.serviceEndpointPrefix;
            this.protocol = src.protocol;
            this.region = src.region;
            this.profileFile = src.profileFile;
            this.profileName = src.profileName;
            this.advancedOptions.putAll(src.advancedOptions);
            this.dualstackEnabled = src.dualstackEnabled;
            this.fipsEnabled = src.fipsEnabled;
            this.serviceEndpointOverrideEnvironmentVariable = src.serviceEndpointOverrideEnvironmentVariable;
            this.serviceEndpointOverrideSystemProperty = src.serviceEndpointOverrideSystemProperty;
            this.serviceProfileProperty = src.serviceProfileProperty;
        }

        public Builder clientEndpointOverride(URI clientEndpointOverride) {
            if (clientEndpointOverride != null) {
                Validate.paramNotNull((Object)clientEndpointOverride.getScheme(), (String)"The scheme of the endpoint override");
            }
            this.clientEndpointOverride = clientEndpointOverride;
            return this;
        }

        public Builder serviceEndpointOverrideEnvironmentVariable(String serviceEndpointOverrideEnvironmentVariable) {
            this.serviceEndpointOverrideEnvironmentVariable = serviceEndpointOverrideEnvironmentVariable;
            return this;
        }

        public Builder serviceEndpointOverrideSystemProperty(String serviceEndpointOverrideSystemProperty) {
            this.serviceEndpointOverrideSystemProperty = serviceEndpointOverrideSystemProperty;
            return this;
        }

        public Builder serviceProfileProperty(String serviceProfileProperty) {
            this.serviceProfileProperty = serviceProfileProperty;
            return this;
        }

        public Builder profileFile(Supplier<ProfileFile> profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public Builder serviceEndpointPrefix(String serviceEndpointPrefix) {
            this.serviceEndpointPrefix = serviceEndpointPrefix;
            return this;
        }

        public Builder defaultProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder dualstackEnabled(Boolean dualstackEnabled) {
            this.dualstackEnabled = dualstackEnabled;
            return this;
        }

        public Builder fipsEnabled(Boolean fipsEnabled) {
            this.fipsEnabled = fipsEnabled;
            return this;
        }

        public <T> Builder putAdvancedOption(ServiceMetadataAdvancedOption<T> option, T value) {
            this.advancedOptions.put(option, value);
            return this;
        }

        public AwsClientEndpointProvider build() {
            return new AwsClientEndpointProvider(this);
        }
    }

    private static final class ClientEndpoint {
        private final URI clientEndpoint;
        private final boolean isEndpointOverridden;

        private ClientEndpoint(URI clientEndpoint, boolean isEndpointOverridden) {
            this.clientEndpoint = clientEndpoint;
            this.isEndpointOverridden = isEndpointOverridden;
        }

        public String toString() {
            return ToString.builder((String)"ClientEndpoint").add("clientEndpoint", (Object)this.clientEndpoint).add("isEndpointOverridden", (Object)this.isEndpointOverridden).build();
        }
    }
}

