/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.Incubating;
import org.hibernate.engine.FetchTiming;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.collection.internal.EagerCollectionFetch;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.entity.internal.AbstractNonJoinedEntityFetch;

@Incubating
public interface FetchList
extends Iterable<Fetch> {
    public int size();

    public boolean isEmpty();

    public Fetch get(Fetchable var1);

    @Override
    public void forEach(Consumer<? super Fetch> var1);

    public void indexedForEach(IndexedConsumer<? super Fetch> var1);

    default public Stream<Fetch> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public boolean hasJoinFetches() {
        for (Fetch fetch : this) {
            if (fetch instanceof BasicFetch || fetch instanceof AbstractNonJoinedEntityFetch || fetch.getTiming() == FetchTiming.DELAYED) continue;
            if (fetch instanceof EmbeddableResultGraphNode) {
                if (!((EmbeddableResultGraphNode)((Object)fetch)).hasJoinFetches()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    default public boolean containsCollectionFetches() {
        for (Fetch fetch : this) {
            if (fetch instanceof EagerCollectionFetch) {
                return true;
            }
            if (fetch.asFetchParent() == null || !fetch.asFetchParent().containsCollectionFetches()) continue;
            return true;
        }
        return false;
    }
}

