/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.shared.common.error.StandardException;

class ResultColumn
extends ValueNode
implements ResultColumnDescriptor,
Comparable<ResultColumn> {
    private String _underlyingName;
    private String _derivedColumnName;
    private String _unqualifiedTableName;
    private String _unqualifiedSourceTableName;
    private String _sourceSchemaName;
    private ValueNode _expression;
    private ColumnDescriptor _columnDescriptor;
    private boolean _isGenerated;
    private boolean _isGeneratedForUnmatchedColumnInInsert;
    private boolean _isGroupingColumn;
    private boolean _isReferenced;
    private boolean _isRedundant;
    private boolean _isNameGenerated;
    private boolean _updated;
    private boolean _updatableByCursor;
    private boolean defaultColumn;
    private boolean wasDefault;
    private boolean rightOuterJoinUsingClause;
    private JoinNode joinResultSet = null;
    private boolean _autoincrementGenerated;
    private boolean _autoincrement;
    private int resultSetNumber = -1;
    private ColumnReference _reference;
    private int virtualColumnId;

    ResultColumn(ContextManager contextManager) {
        super(contextManager);
    }

    ResultColumn(String string, ValueNode valueNode, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.setTypeExpressionAndDefault(valueNode);
        this._derivedColumnName = this._underlyingName = string;
    }

    ResultColumn(ColumnReference columnReference, ValueNode valueNode, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.setTypeExpressionAndDefault(valueNode);
        this._underlyingName = columnReference.getColumnName();
        this._derivedColumnName = columnReference.getColumnName();
        this._reference = columnReference;
    }

    ResultColumn(ColumnDescriptor columnDescriptor, ValueNode valueNode, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.setTypeExpressionAndDefault(valueNode);
        this._derivedColumnName = this._underlyingName = columnDescriptor.getColumnName();
        this.setType(columnDescriptor.getType());
        this._columnDescriptor = columnDescriptor;
        this._autoincrement = columnDescriptor.isAutoincrement();
    }

    ResultColumn(DataTypeDescriptor dataTypeDescriptor, ValueNode valueNode, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.setTypeExpressionAndDefault(valueNode);
        this.setType(dataTypeDescriptor);
        if (this._expression instanceof ColumnReference) {
            this._reference = (ColumnReference)valueNode;
        }
    }

    private void setTypeExpressionAndDefault(ValueNode valueNode) {
        this.setExpression(valueNode);
        if (valueNode != null && valueNode instanceof DefaultNode) {
            this.defaultColumn = true;
        }
    }

    boolean isRightOuterJoinUsingClause() {
        return this.rightOuterJoinUsingClause;
    }

    void setRightOuterJoinUsingClause(boolean bl) {
        this.rightOuterJoinUsingClause = bl;
    }

    JoinNode getJoinResultSet() {
        return this.joinResultSet;
    }

    void setJoinResultset(JoinNode joinNode) {
        this.joinResultSet = joinNode;
    }

    boolean isDefaultColumn() {
        return this.defaultColumn;
    }

    void setDefaultColumn(boolean bl) {
        this.defaultColumn = bl;
    }

    boolean wasDefaultColumn() {
        return this.wasDefault;
    }

    void setWasDefaultColumn(boolean bl) {
        this.wasDefault = bl;
    }

    boolean columnNameMatches(String string) {
        return string.equals(this._derivedColumnName) || string.equals(this._underlyingName) || string.equals(this.getSourceColumnName());
    }

    String getUnderlyingOrAliasName() {
        if (this.getSourceColumnName() != null) {
            return this.getSourceColumnName();
        }
        if (this._underlyingName != null) {
            return this._underlyingName;
        }
        return this._derivedColumnName;
    }

    boolean isUpdatable() {
        return this._derivedColumnName == null || this._underlyingName.equals(this._derivedColumnName);
    }

    String getSourceColumnName() {
        if (this._expression instanceof ColumnReference) {
            return ((ColumnReference)this._expression).getColumnName();
        }
        return null;
    }

    @Override
    public String getName() {
        return this._derivedColumnName;
    }

    @Override
    String getSchemaName() throws StandardException {
        if (this._columnDescriptor != null && this._columnDescriptor.getTableDescriptor() != null) {
            return this._columnDescriptor.getTableDescriptor().getSchemaName();
        }
        if (this._expression != null) {
            return this._expression.getSchemaName();
        }
        return null;
    }

    @Override
    String getTableName() {
        if (this._unqualifiedTableName != null) {
            return this._unqualifiedTableName;
        }
        if (this._columnDescriptor != null && this._columnDescriptor.getTableDescriptor() != null) {
            return this._columnDescriptor.getTableDescriptor().getName();
        }
        return this._expression.getTableName();
    }

    @Override
    public String getSourceTableName() {
        return this._unqualifiedSourceTableName;
    }

    @Override
    public String getSourceSchemaName() {
        return this._sourceSchemaName;
    }

    void clearTableName() {
        if (this._expression instanceof ColumnReference) {
            ((ColumnReference)this._expression).setQualifiedTableName(null);
        }
    }

    @Override
    public DataTypeDescriptor getType() {
        return this.getTypeServices();
    }

    @Override
    public int getColumnPosition() {
        if (this._columnDescriptor != null) {
            return this._columnDescriptor.getPosition();
        }
        return this.virtualColumnId;
    }

    void setExpression(ValueNode valueNode) {
        this._expression = valueNode;
    }

    ValueNode getExpression() {
        return this._expression;
    }

    void setExpressionToNullNode() throws StandardException {
        this.setExpression(this.getNullNode(this.getTypeServices()));
    }

    void setName(String string) {
        if (this._underlyingName == null) {
            this._underlyingName = string;
        }
        this._derivedColumnName = string;
    }

    boolean isNameGenerated() {
        return this._isNameGenerated;
    }

    void setNameGenerated(boolean bl) {
        this._isNameGenerated = bl;
    }

    void setResultSetNumber(int n) {
        this.resultSetNumber = n;
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    void adjustVirtualColumnId(int n) {
        this.virtualColumnId += n;
    }

    void setVirtualColumnId(int n) {
        this.virtualColumnId = n;
    }

    int getVirtualColumnId() {
        return this.virtualColumnId;
    }

    void collapseVirtualColumnIdGap(int n) {
        if (this._columnDescriptor == null && this.virtualColumnId > n) {
            --this.virtualColumnId;
        }
    }

    void guaranteeColumnName() throws StandardException {
        if (this._derivedColumnName == null) {
            this._derivedColumnName = "SQLCol" + this.getCompilerContext().getNextColumnNumber();
            this._isNameGenerated = true;
        }
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    ResultColumn bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        if (this._expression.requiresTypeFromContext() && this.getTypeServices() != null) {
            this._expression.setType(this.getTypeServices());
        }
        if (this._expression.getTableName() == null) {
            fromList.isJoinColumnForRightOuterJoin(this);
        }
        this.setExpression(this._expression.bindExpression(fromList, subqueryList, list));
        if (this._expression instanceof ColumnReference) {
            this._autoincrement = ((ColumnReference)this._expression).getSource().isAutoincrement();
        }
        return this;
    }

    void bindResultColumnByPosition(TableDescriptor tableDescriptor, int n) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(n);
        if (columnDescriptor == null) {
            Object object = "";
            String string = tableDescriptor.getSchemaName();
            if (string != null) {
                object = (String)object + string + ".";
            }
            object = (String)object + tableDescriptor.getName();
            throw StandardException.newException((String)"42X06", (Object[])new Object[]{object});
        }
        this.setColumnDescriptor(tableDescriptor, columnDescriptor);
        this.setVirtualColumnId(n);
    }

    void bindResultColumnByName(TableDescriptor tableDescriptor, int n) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this._derivedColumnName);
        if (columnDescriptor == null) {
            Object object = "";
            String string = tableDescriptor.getSchemaName();
            if (string != null) {
                object = (String)object + string + ".";
            }
            object = (String)object + tableDescriptor.getName();
            throw StandardException.newException((String)"42X14", (Object[])new Object[]{this._derivedColumnName, object});
        }
        this.setColumnDescriptor(tableDescriptor, columnDescriptor);
        this.setVirtualColumnId(n);
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredColumnPriv(columnDescriptor);
        }
    }

    void typeUntypedNullExpression(ResultColumn resultColumn) throws StandardException {
        TypeId typeId = resultColumn.getTypeId();
        if (typeId == null) {
            throw StandardException.newException((String)"42X07", (Object[])new Object[0]);
        }
        if (this._expression instanceof UntypedNullConstantNode) {
            this.setExpression(this.getNullNode(resultColumn.getTypeServices()));
        } else if (this._expression instanceof ColumnReference && this._expression.getTypeServices() == null) {
            this._expression.setType(resultColumn.getType());
        }
    }

    void setColumnDescriptor(TableDescriptor tableDescriptor, ColumnDescriptor columnDescriptor) throws StandardException {
        if (columnDescriptor != null) {
            this.setType(columnDescriptor.getType());
        }
        this._columnDescriptor = columnDescriptor;
        if (this._reference != null && this._reference.getTableName() != null && this._reference.getMergeTableID() == 0 && tableDescriptor != null && !tableDescriptor.getName().equals(this._reference.getTableName())) {
            String string = tableDescriptor.getName();
            String string2 = this._reference.getTableName();
            throw StandardException.newException((String)"42X55", (Object[])new Object[]{string, string2});
        }
    }

    void bindResultColumnToExpression() throws StandardException {
        this.setType(this._expression.getTypeServices());
        if (this._expression instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)this._expression;
            this._unqualifiedTableName = columnReference.getTableName();
            this._unqualifiedSourceTableName = columnReference.getSourceTableName();
            this._sourceSchemaName = columnReference.getSourceSchemaName();
        }
    }

    void setSourceTableName(String string) {
        this._unqualifiedSourceTableName = string;
    }

    void setSourceSchemaName(String string) {
        this._sourceSchemaName = string;
    }

    @Override
    ResultColumn preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        if (this._expression == null) {
            return this;
        }
        this.setExpression(this._expression.preprocess(n, fromList, subqueryList, predicateList));
        return this;
    }

    void checkStorableExpression(ResultColumn resultColumn) throws StandardException {
        this.checkStorableExpression((ValueNode)resultColumn);
    }

    private void checkStorableExpression(ValueNode valueNode) throws StandardException {
        TypeId typeId = valueNode.getTypeId();
        if (!this.getTypeCompiler().storable(typeId, this.getClassFactory())) {
            throw StandardException.newException((String)"42821", (Object[])new Object[]{this.getTypeId().getSQLTypeName(), typeId.getSQLTypeName()});
        }
    }

    void checkStorableExpression() throws StandardException {
        this.checkStorableExpression(this.getExpression());
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this._expression.generateExpression(expressionClassBuilder, methodBuilder);
    }

    boolean columnTypeAndLengthMatch() throws StandardException {
        if (this.getExpression().requiresTypeFromContext()) {
            return false;
        }
        if (this.getTypeId().isXMLTypeId()) {
            return false;
        }
        DataTypeDescriptor dataTypeDescriptor = this.getExpression().getTypeServices();
        if (!this.getTypeServices().isExactTypeAndLengthMatch(dataTypeDescriptor)) {
            return false;
        }
        return this.getTypeServices().isNullable() || !dataTypeDescriptor.isNullable();
    }

    boolean columnTypeAndLengthMatch(ResultColumn resultColumn) throws StandardException {
        ValueNode valueNode = resultColumn.getExpression();
        DataTypeDescriptor dataTypeDescriptor = this.getTypeServices();
        DataTypeDescriptor dataTypeDescriptor2 = resultColumn.getTypeServices();
        if (valueNode != null && valueNode.requiresTypeFromContext() || this._expression.requiresTypeFromContext()) {
            return false;
        }
        if (dataTypeDescriptor.getTypeId().isXMLTypeId()) {
            return false;
        }
        if (!dataTypeDescriptor.getTypeId().equals(dataTypeDescriptor2.getTypeId())) {
            if (valueNode instanceof ConstantNode) {
                DataValueDescriptor dataValueDescriptor;
                ConstantNode constantNode = (ConstantNode)resultColumn.getExpression();
                DataValueDescriptor dataValueDescriptor2 = constantNode.getValue();
                if (dataValueDescriptor2 != (dataValueDescriptor = this.convertConstant(dataTypeDescriptor.getTypeId(), dataTypeDescriptor.getMaximumWidth(), dataValueDescriptor2)) && dataValueDescriptor2 instanceof StringDataValue == dataValueDescriptor instanceof StringDataValue) {
                    constantNode.setValue(dataValueDescriptor);
                    constantNode.setType(this.getTypeServices());
                    resultColumn.bindResultColumnToExpression();
                    dataTypeDescriptor2 = resultColumn.getType();
                }
                if (dataValueDescriptor instanceof StringDataValue) {
                    constantNode.setCollationInfo(dataTypeDescriptor);
                    DataValueFactory dataValueFactory = this.getDataValueFactory();
                    dataValueDescriptor = ((StringDataValue)dataValueDescriptor).getValue(dataValueFactory.getCharacterCollator(constantNode.getTypeServices().getCollationType()));
                    constantNode.setValue(dataValueDescriptor);
                }
            }
            if (!dataTypeDescriptor.getTypeId().equals(dataTypeDescriptor2.getTypeId())) {
                return false;
            }
        }
        if (dataTypeDescriptor.getPrecision() != dataTypeDescriptor2.getPrecision()) {
            return false;
        }
        if (dataTypeDescriptor.getScale() != dataTypeDescriptor2.getScale()) {
            return false;
        }
        if (dataTypeDescriptor.getMaximumWidth() != dataTypeDescriptor2.getMaximumWidth()) {
            return false;
        }
        return dataTypeDescriptor.isNullable() || !dataTypeDescriptor2.isNullable() && !resultColumn.isGeneratedForUnmatchedColumnInInsert();
    }

    boolean isGenerated() {
        return this._isGenerated;
    }

    boolean isGeneratedForUnmatchedColumnInInsert() {
        return this._isGeneratedForUnmatchedColumnInInsert;
    }

    void markGenerated() {
        this._isGenerated = true;
        this._isReferenced = true;
    }

    void markGeneratedForUnmatchedColumnInInsert() {
        this._isGeneratedForUnmatchedColumnInInsert = true;
        this._isReferenced = true;
    }

    boolean isReferenced() {
        return this._isReferenced;
    }

    void setReferenced() {
        this._isReferenced = true;
    }

    void pullVirtualIsReferenced() {
        if (this.isReferenced()) {
            return;
        }
        ValueNode valueNode = this._expression;
        while (valueNode != null && valueNode instanceof VirtualColumnNode) {
            VirtualColumnNode virtualColumnNode = (VirtualColumnNode)valueNode;
            ResultColumn resultColumn = virtualColumnNode.getSourceColumn();
            if (resultColumn.isReferenced()) {
                this.setReferenced();
                return;
            }
            valueNode = resultColumn.getExpression();
        }
    }

    void setUnreferenced() {
        this._isReferenced = false;
    }

    void markAllRCsInChainReferenced() {
        this.setReferenced();
        ValueNode valueNode = this._expression;
        while (valueNode instanceof VirtualColumnNode) {
            VirtualColumnNode virtualColumnNode = (VirtualColumnNode)valueNode;
            ResultColumn resultColumn = virtualColumnNode.getSourceColumn();
            resultColumn.setReferenced();
            valueNode = resultColumn.getExpression();
        }
    }

    boolean isRedundant() {
        return this._isRedundant;
    }

    void setRedundant() {
        this._isRedundant = true;
    }

    void markAsGroupingColumn() {
        this._isGroupingColumn = true;
    }

    void rejectParameter() throws StandardException {
        if (this._expression != null && this._expression.isParameterNode()) {
            throw StandardException.newException((String)"42X34", (Object[])new Object[0]);
        }
    }

    @Override
    public int compareTo(ResultColumn resultColumn) {
        ResultColumn resultColumn2 = resultColumn;
        return this.getColumnPosition() - resultColumn2.getColumnPosition();
    }

    void markUpdated() {
        this._updated = true;
    }

    void markUpdatableByCursor() {
        this._updatableByCursor = true;
    }

    boolean updated() {
        return this._updated;
    }

    @Override
    public boolean updatableByCursor() {
        return this._updatableByCursor;
    }

    ResultColumn cloneMe() throws StandardException {
        ResultColumn resultColumn;
        ValueNode valueNode = this._expression instanceof ColumnReference ? ((ColumnReference)this._expression).getClone() : this._expression;
        if (this._columnDescriptor != null) {
            resultColumn = new ResultColumn(this._columnDescriptor, this._expression, this.getContextManager());
            resultColumn.setExpression(valueNode);
        } else {
            resultColumn = new ResultColumn(this.getName(), valueNode, this.getContextManager());
        }
        resultColumn.setVirtualColumnId(this.getVirtualColumnId());
        resultColumn.setName(this.getName());
        resultColumn.setType(this.getTypeServices());
        resultColumn.setNameGenerated(this.isNameGenerated());
        resultColumn.setSourceTableName(this.getSourceTableName());
        resultColumn.setSourceSchemaName(this.getSourceSchemaName());
        if (this.isGeneratedForUnmatchedColumnInInsert()) {
            resultColumn.markGeneratedForUnmatchedColumnInInsert();
        }
        if (this.isReferenced()) {
            resultColumn.setReferenced();
        }
        if (this.updated()) {
            resultColumn.markUpdated();
        }
        if (this.updatableByCursor()) {
            resultColumn.markUpdatableByCursor();
        }
        if (this.isAutoincrementGenerated()) {
            resultColumn.setAutoincrementGenerated();
        }
        if (this.isAutoincrement()) {
            resultColumn.setAutoincrement();
        }
        if (this.isGroupingColumn()) {
            resultColumn.markAsGroupingColumn();
        }
        if (this.isRightOuterJoinUsingClause()) {
            resultColumn.setRightOuterJoinUsingClause(true);
        }
        if (this.getJoinResultSet() != null) {
            resultColumn.setJoinResultset(this.getJoinResultSet());
        }
        if (this.isGenerated()) {
            resultColumn.markGenerated();
        }
        resultColumn.copyTagsFrom(this);
        return resultColumn;
    }

    int getMaximumColumnSize() {
        return this.getTypeServices().getTypeId().getApproximateLengthInBytes(this.getTypeServices());
    }

    @Override
    public DataTypeDescriptor getTypeServices() {
        DataTypeDescriptor dataTypeDescriptor = super.getTypeServices();
        if (dataTypeDescriptor != null) {
            return dataTypeDescriptor;
        }
        if (this.getExpression() != null) {
            return this.getExpression().getTypeServices();
        }
        return null;
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        int n = this.isAutoincrementGenerated() ? 0 : (this._expression != null ? this._expression.getOrderableVariantType() : 3);
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return 1;
            }
        }
        return 3;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this._expression != null) {
            this.setExpression((ValueNode)this._expression.accept(visitor));
        }
    }

    void verifyOrderable() throws StandardException {
        if (!this.getTypeId().orderable(this.getClassFactory())) {
            throw StandardException.newException((String)"X0X67.S", (Object[])new Object[]{this.getTypeId().getSQLTypeName()});
        }
    }

    ColumnDescriptor getTableColumnDescriptor() {
        return this._columnDescriptor;
    }

    boolean isAutoincrementGenerated() {
        return this._autoincrementGenerated;
    }

    void setAutoincrementGenerated() {
        this._autoincrementGenerated = true;
    }

    void resetAutoincrementGenerated() {
        this._autoincrementGenerated = false;
    }

    @Override
    public boolean isAutoincrement() {
        return this._autoincrement;
    }

    void setAutoincrement() {
        this._autoincrement = true;
    }

    public boolean isGroupingColumn() {
        return this._isGroupingColumn;
    }

    private DataValueDescriptor convertConstant(TypeId typeId, int n, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n2 = typeId.getTypeFormatId();
        DataValueFactory dataValueFactory = this.getDataValueFactory();
        switch (n2) {
            default: {
                return dataValueDescriptor;
            }
            case 13: {
                String string = dataValueDescriptor.getString();
                int n3 = string.length();
                if (n3 <= n && n2 == 13) {
                    return dataValueFactory.getVarcharDataValue(string);
                }
                for (int i = n; i < n3; ++i) {
                    if (string.charAt(i) == ' ') continue;
                    String string2 = null;
                    if (n2 == 13) {
                        string2 = "VARCHAR";
                    }
                    throw StandardException.newException((String)"22001", (Object[])new Object[]{string2, StringUtil.formatForPrint(string), String.valueOf(n)});
                }
                if (n2 != 13) break;
                return dataValueFactory.getVarcharDataValue(string.substring(0, n));
            }
            case 230: 
        }
        return dataValueFactory.getLongvarcharDataValue(dataValueDescriptor.getString());
    }

    public TableName getTableNameObject() {
        return null;
    }

    public ColumnReference getReference() {
        return this._reference;
    }

    ColumnDescriptor getColumnDescriptor() {
        return this._columnDescriptor;
    }

    BaseColumnNode getBaseColumnNode() {
        ValueNode valueNode = this._expression;
        while (true) {
            if (valueNode instanceof ResultColumn) {
                valueNode = ((ResultColumn)valueNode)._expression;
                continue;
            }
            if (valueNode instanceof ColumnReference) {
                valueNode = ((ColumnReference)valueNode).getSource();
                continue;
            }
            if (!(valueNode instanceof VirtualColumnNode)) break;
            valueNode = ((VirtualColumnNode)valueNode).getSourceColumn();
        }
        if (valueNode instanceof BaseColumnNode) {
            return (BaseColumnNode)valueNode;
        }
        return null;
    }

    int getTableNumber() throws StandardException {
        if (this._expression instanceof ColumnReference) {
            return ((ColumnReference)this._expression).getTableNumber();
        }
        if (this._expression instanceof VirtualColumnNode) {
            VirtualColumnNode virtualColumnNode = (VirtualColumnNode)this._expression;
            if (virtualColumnNode.getSourceResultSet() instanceof FromBaseTable) {
                return ((FromBaseTable)virtualColumnNode.getSourceResultSet()).getTableNumber();
            }
            return virtualColumnNode.getSourceColumn().getTableNumber();
        }
        return -1;
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (this.isSameNodeKind(valueNode)) {
            ResultColumn resultColumn = (ResultColumn)valueNode;
            if (this._expression != null) {
                return this._expression.isEquivalent(resultColumn._expression);
            }
        }
        return false;
    }

    @Override
    public boolean hasGenerationClause() {
        return this._columnDescriptor != null && this._columnDescriptor.hasGenerationClause();
    }
}

