/*
 * Decompiled with CFR 0.152.
 */
package kamon.status;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigUtil;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.ThreadLocalRandom;
import kamon.status.Environment;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import kamon.util.HexCodec$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple5;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.runtime.ModuleSerializationProxy;

public final class Environment$
implements Serializable {
    public static final Environment$ MODULE$ = new Environment$();
    private static final Logger _logger = LoggerFactory.getLogger(Environment.class);
    private static final String _incarnation = HexCodec$.MODULE$.toLowerHex(ThreadLocalRandom.current().nextLong());

    private Logger _logger() {
        return _logger;
    }

    private String _incarnation() {
        return _incarnation;
    }

    public Environment from(Config config) {
        Config environmentConfig = config.getConfig("kamon.environment");
        String service = environmentConfig.getString("service");
        Config tagsConfig = environmentConfig.getConfig("tags");
        TagSet tags = this.flattenedTags(tagsConfig);
        String host = this.readValueOrGenerate(environmentConfig.getString("host"), (Function0<String>)(Function0 & Serializable)() -> MODULE$.generateHostname());
        String instance = this.readValueOrGenerate(environmentConfig.getString("instance"), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(1).append(service).append("@").append(host).toString());
        return new Environment(host, service, instance, this._incarnation(), tags);
    }

    private TagSet flattenedTags(Config tagsConfig) {
        return TagSet$.MODULE$.from((Map<String, Object>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(tagsConfig.entrySet().iterator()).asScala()).map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(ConfigUtil.splitPath((String)((String)e.getKey()))).asScala()).mkString(".")), (Object)((ConfigValue)e.getValue()).unwrapped().toString())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private String generateHostname() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable t) {
            this._logger().warn("Could not automatically resolve a host name for this instance, falling back to 'localhost'", t);
            string = "localhost";
        }
        return string;
    }

    private String readValueOrGenerate(String configuredValue, Function0<String> generator) {
        String string = configuredValue;
        String string2 = "auto";
        return !(string != null ? !string.equals(string2) : string2 != null) ? (String)generator.apply() : configuredValue;
    }

    public Environment apply(String host, String service, String instance, String incarnation, TagSet tags) {
        return new Environment(host, service, instance, incarnation, tags);
    }

    public Option<Tuple5<String, String, String, String, TagSet>> unapply(Environment x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.host(), (Object)x$0.service(), (Object)x$0.instance(), (Object)x$0.incarnation(), (Object)x$0.tags()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Environment$.class);
    }

    private Environment$() {
    }
}

