/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Transient;
import java.beans.Introspector;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.ReflectHelper;

public class AccessStrategyHelper {
    public static final int COMPOSITE_TRACKER_MASK = 1;
    public static final int COMPOSITE_OWNER = 2;
    public static final int PERSISTENT_ATTRIBUTE_INTERCEPTABLE_MASK = 4;

    public static Field fieldOrNull(Class<?> containerJavaType, String propertyName) {
        try {
            return ReflectHelper.findField(containerJavaType, propertyName);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    public static AccessType getAccessType(Class<?> containerJavaType, String propertyName) {
        Field field = AccessStrategyHelper.fieldOrNull(containerJavaType, propertyName);
        AccessType explicitAccessType = AccessStrategyHelper.getExplicitAccessType(containerJavaType, propertyName, field);
        if (explicitAccessType != null) {
            return explicitAccessType;
        }
        AccessType classAccessType = AccessStrategyHelper.getAccessTypeOrNull(containerJavaType);
        if (classAccessType != null) {
            return classAccessType;
        }
        return field != null ? AccessType.FIELD : AccessType.PROPERTY;
    }

    public static AccessType getExplicitAccessType(Class<?> containerClass, String propertyName, Field field) {
        if (ReflectHelper.isRecord(containerClass)) {
            try {
                containerClass.getMethod(propertyName, ReflectHelper.NO_PARAM_SIGNATURE);
                return AccessType.PROPERTY;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (field != null && field.isAnnotationPresent(Access.class) && !field.isAnnotationPresent(Transient.class) && !Modifier.isStatic(field.getModifiers())) {
            return AccessType.FIELD;
        }
        for (Method method : containerClass.getDeclaredMethods()) {
            String decapitalizedStemName;
            String stemName;
            if (method.getParameterCount() != 0 || method.isBridge() || method.isAnnotationPresent(Transient.class) || Modifier.isStatic(method.getModifiers())) continue;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                stemName = methodName.substring(3);
                decapitalizedStemName = Introspector.decapitalize(stemName);
                if (stemName.equals(propertyName) || decapitalizedStemName.equals(propertyName)) {
                    if (method.isAnnotationPresent(Access.class)) {
                        return AccessType.PROPERTY;
                    }
                    AccessStrategyHelper.checkIsMethodVariant(containerClass, propertyName, method, stemName);
                }
            }
            if (!methodName.startsWith("is")) continue;
            stemName = methodName.substring(2);
            decapitalizedStemName = Introspector.decapitalize(stemName);
            if (!stemName.equals(propertyName) && !decapitalizedStemName.equals(propertyName) || !method.isAnnotationPresent(Access.class)) continue;
            return AccessType.PROPERTY;
        }
        return null;
    }

    private static void checkIsMethodVariant(Class<?> containerClass, String propertyName, Method method, String stemName) {
        Method isMethodVariant = AccessStrategyHelper.findIsMethodVariant(containerClass, stemName);
        if (isMethodVariant == null) {
            return;
        }
        if (!isMethodVariant.isAnnotationPresent(Access.class)) {
            throw new MappingException(String.format(Locale.ROOT, "In trying to locate getter for property [%s], Class [%s] defined both a `get` [%s] and `is` [%s] variant", propertyName, containerClass.getName(), method.toString(), isMethodVariant.toString()));
        }
    }

    public static Method findIsMethodVariant(Class<?> containerClass, String stemName) {
        try {
            Method isMethod = containerClass.getDeclaredMethod("is" + stemName, new Class[0]);
            if (!Modifier.isStatic(isMethod.getModifiers()) && isMethod.getAnnotation(Transient.class) == null) {
                return isMethod;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    protected static AccessType getAccessTypeOrNull(AnnotatedElement element) {
        if (element == null) {
            return null;
        }
        Access elementAccess = element.getAnnotation(Access.class);
        return elementAccess == null ? null : elementAccess.value();
    }

    public static int determineEnhancementState(Class<?> containerClass, Class<?> attributeType) {
        return (CompositeOwner.class.isAssignableFrom(containerClass) ? 2 : 0) | (CompositeTracker.class.isAssignableFrom(attributeType) ? 1 : 0) | (ManagedTypeHelper.isPersistentAttributeInterceptableType(containerClass) ? 4 : 0);
    }

    public static void handleEnhancedInjection(Object target, Object value, int enhancementState, String propertyName) {
        PersistentAttributeInterceptor interceptor;
        if ((enhancementState & 2) != 0 && ((enhancementState & 1) != 0 && value != null || ManagedTypeHelper.isCompositeTracker(value))) {
            ManagedTypeHelper.asCompositeTracker(value).$$_hibernate_setOwner(propertyName, ManagedTypeHelper.asCompositeOwner(target));
        }
        if ((enhancementState & 4) != 0 && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(target).$$_hibernate_getInterceptor()) instanceof BytecodeLazyAttributeInterceptor) {
            ((BytecodeLazyAttributeInterceptor)interceptor).attributeInitialized(propertyName);
        }
    }
}

