/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RegularExpressionPasswordResponseProvider
implements ChallengeResponseProvider {
    private static final char[] EMPTY_RESPONSE = new char[0];
    private final Pattern passwordPromptRegex;
    private Resource<?> resource;
    private PasswordFinder passwordFinder;
    private boolean gaveAlready;
    private static final Logger logger = LoggerFactory.getLogger(RegularExpressionPasswordResponseProvider.class);

    public RegularExpressionPasswordResponseProvider(PasswordFinder pwdf, String passwordPromptRegex) {
        this.passwordFinder = pwdf;
        this.passwordPromptRegex = Pattern.compile(passwordPromptRegex);
    }

    public List<String> getSubmethods() {
        return Collections.emptyList();
    }

    public void init(Resource resource, String name, String instruction) {
        this.resource = resource;
        logger.debug("Initializing - name=[{}], instruction=[{}]", (Object)name, (Object)instruction);
    }

    public char[] getResponse(String prompt, boolean echo) {
        if (!this.gaveAlready && !echo && this.passwordPromptRegex.matcher(prompt).matches()) {
            this.gaveAlready = true;
            return this.passwordFinder.reqPassword(this.resource);
        }
        return EMPTY_RESPONSE;
    }

    public boolean shouldRetry() {
        return this.passwordFinder.shouldRetry(this.resource);
    }
}

