/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2.client;

import java.io.Serializable;
import javax.net.ssl.SSLSession;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.Http2SubStream;
import org.apache.pekko.http.impl.engine.http2.RequestParsing$;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser;
import org.apache.pekko.http.impl.engine.server.HttpAttributes;
import org.apache.pekko.http.javadsl.model.AttributeKey;
import org.apache.pekko.http.scaladsl.model.AttributeKeys$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentType$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.HttpProtocols$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.SslSessionInfo$;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCode$;
import org.apache.pekko.http.scaladsl.model.headers.Tls$minusSession$minusInfo;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

@InternalApi
public final class ResponseParsing$ {
    public static final ResponseParsing$ MODULE$ = new ResponseParsing$();

    public Function1<Http2SubStream, HttpResponse> parseResponse(HttpHeaderParser httpHeaderParser, ParserSettings settings, Attributes attributes) {
        return (Function1 & Serializable)subStream -> {
            None$ tlsSessionInfoHeader = settings.includeTlsSessionInfoHeader() ? attributes.get(ClassTag$.MODULE$.apply(HttpAttributes.TLSSessionInfo.class)).map((Function1 & Serializable)sslSessionInfo -> new Tls$minusSession$minusInfo(sslSessionInfo.session())) : None$.MODULE$;
            None$ sslSessionAttribute = settings.includeSslSessionAttribute() ? attributes.get(ClassTag$.MODULE$.apply(HttpAttributes.TLSSessionInfo.class)).map((Function1 & Serializable)x$1 -> x$1.session()) : None$.MODULE$;
            return this.rec$1((Seq)subStream.initialHeaders().keyValuePairs(), ResponseParsing$.rec$default$2$1(), ResponseParsing$.rec$default$3$1(), ResponseParsing$.rec$default$4$1(), ResponseParsing$.rec$default$5$1(), ResponseParsing$.rec$default$6$1(), (Http2SubStream)subStream, (Option)tlsSessionInfoHeader, (Option)sslSessionAttribute, httpHeaderParser);
        };
    }

    private final HttpResponse rec$1(Seq remainingHeaders, StatusCode status, ContentType contentType, long contentLength, boolean seenRegularHeader, VectorBuilder headers2, Http2SubStream subStream$1, Option tlsSessionInfoHeader$1, Option sslSessionAttribute$1, HttpHeaderParser httpHeaderParser$1) {
        Tuple2 tuple2;
        while (true) {
            Object httpHeader;
            String name;
            if (remainingHeaders.isEmpty()) {
                RequestParsing$.MODULE$.checkRequiredPseudoHeader(":status", status);
                RequestEntity entity = subStream$1.createEntity(contentLength, contentType);
                Object object = tlsSessionInfoHeader$1.isDefined() ? headers2.$plus$eq(tlsSessionInfoHeader$1.get()) : BoxedUnit.UNIT;
                HttpMessage response = HttpResponse$.MODULE$.apply(status, (Seq<HttpHeader>)headers2.result(), entity, HttpProtocols$.MODULE$.HTTP$div2$u002E0()).withAttributes((Map)subStream$1.correlationAttributes());
                Option option = sslSessionAttribute$1;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SSLSession sslSession = (SSLSession)some.value();
                    return (HttpResponse)((HttpResponse)response).addAttribute((AttributeKey)AttributeKeys$.MODULE$.sslSession(), SslSessionInfo$.MODULE$.apply(sslSession));
                }
                if (None$.MODULE$.equals(option)) {
                    return response;
                }
                throw new MatchError((Object)option);
            }
            tuple2 = (Tuple2)remainingHeaders.head();
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                Object statusCodeValue = tuple2._2();
                if (":status".equals(string) && statusCodeValue instanceof String) {
                    String string2 = (String)statusCodeValue;
                    RequestParsing$.MODULE$.checkUniquePseudoHeader(":status", status);
                    RequestParsing$.MODULE$.checkNoRegularHeadersBeforePseudoHeader(":status", seenRegularHeader);
                    status = StatusCode$.MODULE$.int2StatusCode(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(string2)));
                    remainingHeaders = (Seq)remainingHeaders.tail();
                    continue;
                }
            }
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                Object contentTypeValue = tuple2._2();
                if ("content-type".equals(string) && contentTypeValue instanceof ContentType) {
                    ContentType contentType2 = (ContentType)contentTypeValue;
                    if (OptionVal$.MODULE$.isEmpty$extension((Object)contentType)) {
                        contentType = (ContentType)OptionVal.Some$.MODULE$.apply((Object)contentType2);
                        remainingHeaders = (Seq)remainingHeaders.tail();
                        continue;
                    }
                    throw RequestParsing$.MODULE$.malformedRequest("HTTP message must not contain more than one content-type header");
                }
            }
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                Object ct = tuple2._2();
                if ("content-type".equals(string) && ct instanceof String) {
                    String string3 = (String)ct;
                    if (OptionVal$.MODULE$.isEmpty$extension((Object)contentType)) {
                        ContentType contentTypeValue = (ContentType)ContentType$.MODULE$.parse(string3).right().getOrElse((Function0 & Serializable)() -> RequestParsing$.MODULE$.malformedRequest(new StringBuilder(24).append("Invalid content-type: '").append(string3).append("'").toString()));
                        contentType = (ContentType)OptionVal.Some$.MODULE$.apply((Object)contentTypeValue);
                        remainingHeaders = (Seq)remainingHeaders.tail();
                        continue;
                    }
                    throw RequestParsing$.MODULE$.malformedRequest("HTTP message must not contain more than one content-type header");
                }
            }
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                Object length = tuple2._2();
                if ("content-length".equals(string) && length instanceof String) {
                    String string4 = (String)length;
                    if (contentLength == -1L) {
                        long contentLengthValue = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(string4));
                        if (contentLengthValue < 0L) {
                            throw RequestParsing$.MODULE$.malformedRequest("HTTP message must not contain a negative content-length header");
                        }
                        contentLength = contentLengthValue;
                        remainingHeaders = (Seq)remainingHeaders.tail();
                        continue;
                    }
                    throw RequestParsing$.MODULE$.malformedRequest("HTTP message must not contain more than one content-length header");
                }
            }
            if (tuple2 != null && (name = (String)tuple2._1()).startsWith(":")) {
                throw RequestParsing$.MODULE$.malformedRequest(new StringBuilder(39).append("Unexpected pseudo-header '").append(name).append("' in response").toString());
            }
            if (tuple2 != null && (httpHeader = tuple2._2()) instanceof HttpHeader) {
                HttpHeader httpHeader2 = (HttpHeader)httpHeader;
                headers2 = (VectorBuilder)headers2.$plus$eq((Object)httpHeader2);
                seenRegularHeader = true;
                remainingHeaders = (Seq)remainingHeaders.tail();
                continue;
            }
            if (tuple2 == null) break;
            String name2 = (String)tuple2._1();
            Object value = tuple2._2();
            if (!(value instanceof String)) break;
            String string = (String)value;
            HttpHeader httpHeader3 = RequestParsing$.MODULE$.parseHeaderPair(httpHeaderParser$1, name2, string);
            RequestParsing$.MODULE$.validateHeader(httpHeader3);
            headers2 = (VectorBuilder)headers2.$plus$eq((Object)httpHeader3);
            seenRegularHeader = true;
            remainingHeaders = (Seq)remainingHeaders.tail();
        }
        throw new MatchError((Object)tuple2);
    }

    private static final StatusCode rec$default$2$1() {
        return null;
    }

    private static final ContentType rec$default$3$1() {
        OptionVal$.MODULE$.None();
        return null;
    }

    private static final long rec$default$4$1() {
        return -1L;
    }

    private static final boolean rec$default$5$1() {
        return false;
    }

    private static final VectorBuilder rec$default$6$1() {
        return new VectorBuilder();
    }

    private ResponseParsing$() {
    }
}

