/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum JavaType {
    INT{

        @Override
        Object fromString(String input) {
            return Integer.valueOf(input);
        }

        @Override
        public String defaultValueAsString() {
            return "0";
        }
    }
    ,
    LONG{

        @Override
        Object fromString(String input) {
            return Long.valueOf(input);
        }

        @Override
        public String defaultValueAsString() {
            return "0";
        }
    }
    ,
    FLOAT{

        @Override
        Object fromString(String input) {
            return Float.valueOf(input);
        }

        @Override
        public String defaultValueAsString() {
            return "0f";
        }
    }
    ,
    DOUBLE{

        @Override
        Object fromString(String input) {
            return Double.valueOf(input);
        }

        @Override
        public String defaultValueAsString() {
            return "0d";
        }
    }
    ,
    BOOLEAN{

        @Override
        Object fromString(String input) {
            return Boolean.valueOf(input);
        }

        @Override
        public String defaultValueAsString() {
            return "false";
        }
    }
    ,
    STRING{

        @Override
        Object fromString(String input) {
            return input;
        }

        @Override
        public String defaultValueAsString() {
            return "\"\"";
        }
    }
    ,
    BYTE_STRING{

        @Override
        Object fromString(String input) {
            return null;
        }

        @Override
        public String defaultValueAsString() {
            return "[]";
        }
    }
    ,
    ENUM{

        @Override
        Object fromString(String input) {
            return null;
        }

        @Override
        public String defaultValueAsString() {
            return "null";
        }
    }
    ,
    MESSAGE{

        @Override
        Object fromString(String input) {
            return null;
        }

        @Override
        public String defaultValueAsString() {
            return "null";
        }
    }
    ,
    MAP{

        @Override
        Object fromString(String input) {
            return null;
        }

        @Override
        public String defaultValueAsString() {
            return "null";
        }
    };


    abstract Object fromString(String var1);

    public abstract String defaultValueAsString();
}

