/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Internal;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.internal.util.collections.JoinedIterator;
import org.hibernate.internal.util.collections.JoinedList;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public class DenormalizedTable
extends Table {
    private final Table includedTable;
    private List<Column> reorderedColumns;

    public DenormalizedTable(String contributor, Namespace namespace, Identifier physicalTableName, boolean isAbstract, Table includedTable) {
        super(contributor, namespace, physicalTableName, isAbstract);
        this.includedTable = includedTable;
        includedTable.setHasDenormalizedTables();
    }

    public DenormalizedTable(String contributor, Namespace namespace, Identifier physicalTableName, String subselectFragment, boolean isAbstract, Table includedTable) {
        super(contributor, namespace, physicalTableName, subselectFragment, isAbstract);
        this.includedTable = includedTable;
        includedTable.setHasDenormalizedTables();
    }

    public DenormalizedTable(String contributor, Namespace namespace, String subselect, boolean isAbstract, Table includedTable) {
        super(contributor, namespace, subselect, isAbstract);
        this.includedTable = includedTable;
        includedTable.setHasDenormalizedTables();
    }

    @Override
    public void createForeignKeys() {
        this.includedTable.createForeignKeys();
        for (ForeignKey foreignKey : this.includedTable.getForeignKeys().values()) {
            this.createForeignKey(Constraint.generateName(foreignKey.generatedConstraintNamePrefix(), (Table)this, foreignKey.getColumns()), foreignKey.getColumns(), foreignKey.getReferencedEntityName(), foreignKey.getKeyDefinition(), foreignKey.getReferencedColumns());
        }
    }

    @Override
    public Column getColumn(Column column) {
        Column superColumn = super.getColumn(column);
        return superColumn != null ? superColumn : this.includedTable.getColumn(column);
    }

    @Override
    public Column getColumn(Identifier name) {
        Column superColumn = super.getColumn(name);
        return superColumn != null ? superColumn : this.includedTable.getColumn(name);
    }

    @Override
    @Deprecated
    public Iterator<Column> getColumnIterator() {
        if (this.reorderedColumns != null) {
            return this.reorderedColumns.iterator();
        }
        return new JoinedIterator<Column>(this.includedTable.getColumnIterator(), super.getColumnIterator());
    }

    @Override
    public Collection<Column> getColumns() {
        if (this.reorderedColumns != null) {
            return this.reorderedColumns;
        }
        return new JoinedList<Column>(new ArrayList<Column>(this.includedTable.getColumns()), new ArrayList<Column>(super.getColumns()));
    }

    @Override
    public boolean containsColumn(Column column) {
        return super.containsColumn(column) || this.includedTable.containsColumn(column);
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        return this.includedTable.getPrimaryKey();
    }

    @Override
    @Deprecated
    public Iterator<UniqueKey> getUniqueKeyIterator() {
        if (!this.includedTable.isPhysicalTable()) {
            for (UniqueKey uniqueKey : this.includedTable.getUniqueKeys().values()) {
                this.createUniqueKey(uniqueKey.getColumns());
            }
        }
        return this.getUniqueKeys().values().iterator();
    }

    @Override
    @Deprecated
    public Iterator<Index> getIndexIterator() {
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (Index parentIndex : this.includedTable.getIndexes().values()) {
            Index index = new Index();
            index.setName(this.getName() + parentIndex.getName());
            index.setTable(this);
            index.addColumns(parentIndex.getColumns());
            indexes.add(index);
        }
        return new JoinedIterator<Index>(indexes.iterator(), super.getIndexIterator());
    }

    public Table getIncludedTable() {
        return this.includedTable;
    }

    @Override
    @Internal
    public void reorderColumns(List<Column> columns) {
        assert (this.includedTable.getColumns().size() + super.getColumns().size() == columns.size() && columns.containsAll(this.includedTable.getColumns()) && columns.containsAll(super.getColumns()) && this.reorderedColumns == null);
        this.reorderedColumns = columns;
    }
}

