/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.collections.AbstractHashMapPersister;
import org.apache.activemq.artemis.core.server.impl.AckReason;

public final class AckRetry {
    String nodeID;
    byte[] temporaryNodeBytes;
    long messageID;
    AckReason reason;
    short pageAttempts;
    short queueAttempts;
    private static Persister persister = new Persister();

    public static Persister getPersister() {
        return persister;
    }

    public String toString() {
        return "ACKRetry{nodeID='" + this.nodeID + "', messageID=" + this.messageID + ", reason=" + this.reason + "}";
    }

    public AckRetry() {
    }

    public AckRetry(String nodeID, long messageID, AckReason reason) {
        this.nodeID = nodeID;
        this.messageID = messageID;
        this.reason = reason;
    }

    public byte[] getTemporaryNodeBytes() {
        if (this.temporaryNodeBytes == null) {
            this.temporaryNodeBytes = this.nodeID.getBytes(StandardCharsets.US_ASCII);
        }
        return this.temporaryNodeBytes;
    }

    public void clearTemporaryNodeBytes() {
        this.temporaryNodeBytes = null;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public AckRetry setNodeID(String nodeID) {
        this.nodeID = nodeID;
        return this;
    }

    public long getMessageID() {
        return this.messageID;
    }

    public AckRetry setMessageID(long messageID) {
        this.messageID = messageID;
        return this;
    }

    public AckReason getReason() {
        return this.reason;
    }

    public AckRetry setReason(AckReason reason) {
        this.reason = reason;
        return this;
    }

    public short getPageAttempts() {
        return this.pageAttempts;
    }

    public short getQueueAttempts() {
        return this.queueAttempts;
    }

    public short attemptedPage() {
        this.pageAttempts = (short)(this.pageAttempts + 1);
        return this.pageAttempts;
    }

    public short attemptedQueue() {
        this.queueAttempts = (short)(this.queueAttempts + 1);
        return this.queueAttempts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AckRetry retry = (AckRetry)o;
        if (this.messageID != retry.messageID) {
            return false;
        }
        return Objects.equals(this.nodeID, retry.nodeID);
    }

    public int hashCode() {
        int result = this.nodeID != null ? this.nodeID.hashCode() : 0;
        result = 31 * result + (int)(this.messageID ^ this.messageID >>> 32);
        return result;
    }

    public static class Persister
    extends AbstractHashMapPersister<AckRetry, AckRetry> {
        private Persister() {
        }

        protected int getKeySize(AckRetry key) {
            return 4 + (key.getNodeID() == null ? 0 : key.getTemporaryNodeBytes().length) + 8 + 1;
        }

        protected void encodeKey(ActiveMQBuffer buffer, AckRetry key) {
            if (key.getNodeID() == null) {
                buffer.writeInt(0);
            } else {
                byte[] temporaryNodeBytes = key.getTemporaryNodeBytes();
                buffer.writeInt(temporaryNodeBytes.length);
                buffer.writeBytes(temporaryNodeBytes);
            }
            buffer.writeLong(key.messageID);
            buffer.writeByte(key.reason.getVal());
            key.clearTemporaryNodeBytes();
        }

        protected AckRetry decodeKey(ActiveMQBuffer buffer) {
            String nodeID;
            int sizeBytes = buffer.readInt();
            if (sizeBytes == 0) {
                nodeID = null;
            } else {
                byte[] temporaryNodeBytes = new byte[sizeBytes];
                buffer.readBytes(temporaryNodeBytes);
                nodeID = new String(temporaryNodeBytes, StandardCharsets.US_ASCII);
            }
            long messageID = buffer.readLong();
            AckReason reason = AckReason.fromValue(buffer.readByte());
            return new AckRetry(nodeID, messageID, reason);
        }

        protected int getValueSize(AckRetry value) {
            return 0;
        }

        protected void encodeValue(ActiveMQBuffer buffer, AckRetry value) {
        }

        protected AckRetry decodeValue(ActiveMQBuffer buffer, AckRetry key) {
            return key;
        }
    }
}

