/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.ConnectorServiceConfiguration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationBrokerPlugin;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.routing.ConnectionRouterConfiguration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.SecuritySettingPlugin;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.core.server.metrics.ActiveMQMetricsPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerAddressPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBridgePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConnectionPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConsumerPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerCriticalPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerFederationPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerMessagePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerQueuePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerResourcePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerSessionPlugin;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.ResourceLimitSettings;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerPolicy;

public interface Configuration {
    public String getName();

    public Configuration setName(String var1);

    public Configuration setSystemPropertyPrefix(String var1);

    public String getSystemPropertyPrefix();

    public Configuration parseProperties(String var1) throws Exception;

    public void parsePrefixedProperties(Object var1, String var2, Properties var3, String var4) throws Exception;

    public boolean isCriticalAnalyzer();

    public Configuration setCriticalAnalyzer(boolean var1);

    public long getCriticalAnalyzerTimeout();

    public Configuration setCriticalAnalyzerTimeout(long var1);

    public long getCriticalAnalyzerCheckPeriod();

    public Configuration setCriticalAnalyzerCheckPeriod(long var1);

    public CriticalAnalyzerPolicy getCriticalAnalyzerPolicy();

    public Configuration setCriticalAnalyzerPolicy(CriticalAnalyzerPolicy var1);

    public boolean isClustered();

    public boolean isPersistDeliveryCountBeforeDelivery();

    public Configuration setPersistDeliveryCountBeforeDelivery(boolean var1);

    public boolean isPersistenceEnabled();

    public Configuration setPersistenceEnabled(boolean var1);

    public Configuration setMaxRedeliveryRecords(int var1);

    public int getMaxRedeliveryRecords();

    public boolean isJournalDatasync();

    public Configuration setJournalDatasync(boolean var1);

    public Map<String, ResourceLimitSettings> getResourceLimitSettings();

    public Configuration setResourceLimitSettings(Map<String, ResourceLimitSettings> var1);

    public Configuration addResourceLimitSettings(ResourceLimitSettings var1);

    public long getFileDeployerScanPeriod();

    public Configuration setFileDeployerScanPeriod(long var1);

    public int getThreadPoolMaxSize();

    public Configuration setThreadPoolMaxSize(int var1);

    public int getScheduledThreadPoolMaxSize();

    public Configuration setScheduledThreadPoolMaxSize(int var1);

    public long getSecurityInvalidationInterval();

    public Configuration setSecurityInvalidationInterval(long var1);

    public Configuration setAuthenticationCacheSize(long var1);

    public long getAuthenticationCacheSize();

    public Configuration setAuthorizationCacheSize(long var1);

    public long getAuthorizationCacheSize();

    public boolean isSecurityEnabled();

    public Configuration setSecurityEnabled(boolean var1);

    public boolean isGracefulShutdownEnabled();

    public Configuration setGracefulShutdownEnabled(boolean var1);

    public long getGracefulShutdownTimeout();

    public Configuration setGracefulShutdownTimeout(long var1);

    public boolean isJMXManagementEnabled();

    public Configuration setJMXManagementEnabled(boolean var1);

    public String getJMXDomain();

    public Configuration setJMXDomain(String var1);

    public boolean isJMXUseBrokerName();

    public ConfigurationImpl setJMXUseBrokerName(boolean var1);

    public List<String> getIncomingInterceptorClassNames();

    public List<String> getOutgoingInterceptorClassNames();

    public Configuration setIncomingInterceptorClassNames(List<String> var1);

    public Configuration setOutgoingInterceptorClassNames(List<String> var1);

    public long getConnectionTTLOverride();

    public Configuration setConnectionTTLOverride(long var1);

    public boolean isAmqpUseCoreSubscriptionNaming();

    public Configuration setAmqpUseCoreSubscriptionNaming(boolean var1);

    @Deprecated
    public boolean isAsyncConnectionExecutionEnabled();

    @Deprecated
    public Configuration setEnabledAsyncConnectionExecution(boolean var1);

    public Set<TransportConfiguration> getAcceptorConfigurations();

    public Configuration setAcceptorConfigurations(Set<TransportConfiguration> var1);

    public Configuration addAcceptorConfiguration(TransportConfiguration var1);

    public Configuration addAcceptorConfiguration(String var1, String var2) throws Exception;

    public Configuration clearAcceptorConfigurations();

    public Map<String, TransportConfiguration> getConnectorConfigurations();

    public Configuration setConnectorConfigurations(Map<String, TransportConfiguration> var1);

    public Configuration addConnectorConfiguration(String var1, TransportConfiguration var2);

    public Configuration addConnectorConfiguration(String var1, String var2) throws Exception;

    public Configuration clearConnectorConfigurations();

    public List<BroadcastGroupConfiguration> getBroadcastGroupConfigurations();

    public Configuration setBroadcastGroupConfigurations(List<BroadcastGroupConfiguration> var1);

    public Configuration addBroadcastGroupConfiguration(BroadcastGroupConfiguration var1);

    public Map<String, DiscoveryGroupConfiguration> getDiscoveryGroupConfigurations();

    public Configuration setDiscoveryGroupConfigurations(Map<String, DiscoveryGroupConfiguration> var1);

    public Configuration addDiscoveryGroupConfiguration(String var1, DiscoveryGroupConfiguration var2);

    public GroupingHandlerConfiguration getGroupingHandlerConfiguration();

    public Configuration setGroupingHandlerConfiguration(GroupingHandlerConfiguration var1);

    public List<BridgeConfiguration> getBridgeConfigurations();

    public Configuration setBridgeConfigurations(List<BridgeConfiguration> var1);

    public List<DivertConfiguration> getDivertConfigurations();

    public Configuration setDivertConfigurations(List<DivertConfiguration> var1);

    public Configuration addDivertConfiguration(DivertConfiguration var1);

    public List<ConnectionRouterConfiguration> getConnectionRouters();

    public Configuration setConnectionRouters(List<ConnectionRouterConfiguration> var1);

    public Configuration addConnectionRouter(ConnectionRouterConfiguration var1);

    public List<ClusterConnectionConfiguration> getClusterConfigurations();

    public Configuration setClusterConfigurations(List<ClusterConnectionConfiguration> var1);

    public Configuration addClusterConfiguration(ClusterConnectionConfiguration var1);

    public ClusterConnectionConfiguration addClusterConfiguration(String var1, String var2) throws Exception;

    public Configuration clearClusterConfigurations();

    public Configuration addAMQPConnection(AMQPBrokerConnectConfiguration var1);

    public List<AMQPBrokerConnectConfiguration> getAMQPConnection();

    public Configuration setAMQPConnectionConfigurations(List<AMQPBrokerConnectConfiguration> var1);

    public Configuration clearAMQPConnectionConfigurations();

    @Deprecated
    public List<CoreQueueConfiguration> getQueueConfigurations();

    public List<QueueConfiguration> getQueueConfigs();

    @Deprecated
    public Configuration setQueueConfigurations(List<CoreQueueConfiguration> var1);

    public Configuration setQueueConfigs(List<QueueConfiguration> var1);

    @Deprecated
    public Configuration addQueueConfiguration(CoreQueueConfiguration var1);

    public Configuration addQueueConfiguration(QueueConfiguration var1);

    public List<CoreAddressConfiguration> getAddressConfigurations();

    public Configuration setAddressConfigurations(List<CoreAddressConfiguration> var1);

    public Configuration addAddressConfiguration(CoreAddressConfiguration var1);

    public SimpleString getManagementAddress();

    public Configuration setManagementAddress(SimpleString var1);

    public SimpleString getManagementNotificationAddress();

    public Configuration setManagementNotificationAddress(SimpleString var1);

    public String getClusterUser();

    public Configuration setClusterUser(String var1);

    public String getClusterPassword();

    public Configuration setClusterPassword(String var1);

    public int getIDCacheSize();

    public Configuration setIDCacheSize(int var1);

    public boolean isPersistIDCache();

    public Configuration setPersistIDCache(boolean var1);

    public String getBindingsDirectory();

    public File getBindingsLocation();

    public Configuration setBindingsDirectory(String var1);

    public int getPageMaxConcurrentIO();

    public Configuration setPageMaxConcurrentIO(int var1);

    public boolean isReadWholePage();

    public Configuration setReadWholePage(boolean var1);

    public String getJournalDirectory();

    public File getJournalLocation();

    public File getNodeManagerLockLocation();

    public Configuration setNodeManagerLockDirectory(String var1);

    public String getNodeManagerLockDirectory();

    public Configuration setJournalDirectory(String var1);

    public String getJournalRetentionDirectory();

    public Configuration setJournalRetentionDirectory(String var1);

    public File getJournalRetentionLocation();

    public long getJournalRetentionPeriod();

    public Configuration setJournalRetentionPeriod(TimeUnit var1, long var2);

    public long getJournalRetentionMaxBytes();

    public Configuration setJournalRetentionMaxBytes(long var1);

    public JournalType getJournalType();

    public Configuration setJournalType(JournalType var1);

    public boolean isJournalSyncTransactional();

    public Configuration setJournalSyncTransactional(boolean var1);

    public boolean isJournalSyncNonTransactional();

    public Configuration setJournalSyncNonTransactional(boolean var1);

    public int getJournalFileSize();

    public Configuration setJournalFileSize(int var1);

    public int getJournalCompactMinFiles();

    public Configuration setJournalCompactMinFiles(int var1);

    public int getJournalPoolFiles();

    public Configuration setJournalPoolFiles(int var1);

    public int getJournalCompactPercentage();

    public int getJournalFileOpenTimeout();

    public Configuration setJournalFileOpenTimeout(int var1);

    public Configuration setJournalCompactPercentage(int var1);

    public int getJournalMinFiles();

    public Configuration setJournalMinFiles(int var1);

    public int getJournalMaxIO_AIO();

    public Configuration setJournalMaxIO_AIO(int var1);

    public int getJournalBufferTimeout_AIO();

    public Configuration setJournalBufferTimeout_AIO(int var1);

    public Integer getJournalDeviceBlockSize();

    public Configuration setJournalDeviceBlockSize(Integer var1);

    public int getJournalBufferSize_AIO();

    public Configuration setJournalBufferSize_AIO(int var1);

    public int getJournalMaxIO_NIO();

    public Configuration setJournalMaxIO_NIO(int var1);

    public int getJournalBufferTimeout_NIO();

    public Configuration setJournalBufferTimeout_NIO(int var1);

    public int getJournalBufferSize_NIO();

    public Configuration setJournalBufferSize_NIO(int var1);

    public int getJournalMaxAtticFiles();

    public Configuration setJournalMaxAtticFiles(int var1);

    public boolean isCreateBindingsDir();

    public Configuration setCreateBindingsDir(boolean var1);

    public boolean isCreateJournalDir();

    public Configuration setCreateJournalDir(boolean var1);

    public boolean isLogJournalWriteRate();

    public Configuration setLogJournalWriteRate(boolean var1);

    public long getServerDumpInterval();

    public Configuration setServerDumpInterval(long var1);

    public int getMemoryWarningThreshold();

    public Configuration setMemoryWarningThreshold(int var1);

    public long getMemoryMeasureInterval();

    public Configuration setMemoryMeasureInterval(long var1);

    public String getPagingDirectory();

    public Configuration setPagingDirectory(String var1);

    public File getPagingLocation();

    public String getLargeMessagesDirectory();

    public File getLargeMessagesLocation();

    public Configuration setLargeMessagesDirectory(String var1);

    public boolean isWildcardRoutingEnabled();

    public Configuration setWildcardRoutingEnabled(boolean var1);

    public WildcardConfiguration getWildcardConfiguration();

    public Configuration setWildCardConfiguration(WildcardConfiguration var1);

    public long getTransactionTimeout();

    public Configuration setTransactionTimeout(long var1);

    public boolean isMessageCounterEnabled();

    public Configuration setMessageCounterEnabled(boolean var1);

    public long getMessageCounterSamplePeriod();

    public Configuration setMessageCounterSamplePeriod(long var1);

    public int getMessageCounterMaxDayHistory();

    public Configuration setMessageCounterMaxDayHistory(int var1);

    public long getTransactionTimeoutScanPeriod();

    public Configuration setTransactionTimeoutScanPeriod(long var1);

    public long getMessageExpiryScanPeriod();

    public Configuration setMessageExpiryScanPeriod(long var1);

    @Deprecated
    public int getMessageExpiryThreadPriority();

    @Deprecated
    public Configuration setMessageExpiryThreadPriority(int var1);

    public long getAddressQueueScanPeriod();

    public Configuration setAddressQueueScanPeriod(long var1);

    public Map<String, AddressSettings> getAddressSettings();

    public Configuration setAddressSettings(Map<String, AddressSettings> var1);

    public Configuration addAddressSetting(String var1, AddressSettings var2);

    public Configuration clearAddressSettings();

    @Deprecated
    public Map<String, AddressSettings> getAddressesSettings();

    @Deprecated
    public Configuration setAddressesSettings(Map<String, AddressSettings> var1);

    @Deprecated
    public Configuration addAddressesSetting(String var1, AddressSettings var2);

    @Deprecated
    public Configuration clearAddressesSettings();

    public Configuration setSecurityRoles(Map<String, Set<Role>> var1);

    public Map<String, Set<Role>> getSecurityRoles();

    public Configuration addSecurityRoleNameMapping(String var1, Set<String> var2);

    public Map<String, Set<String>> getSecurityRoleNameMappings();

    public Configuration putSecurityRoles(String var1, Set<Role> var2);

    public Configuration setConnectorServiceConfigurations(List<ConnectorServiceConfiguration> var1);

    public Configuration addConnectorServiceConfiguration(ConnectorServiceConfiguration var1);

    public Configuration setSecuritySettingPlugins(List<SecuritySettingPlugin> var1);

    public Configuration addSecuritySettingPlugin(SecuritySettingPlugin var1);

    @Deprecated
    public Configuration setMetricsPlugin(ActiveMQMetricsPlugin var1);

    public Configuration setMetricsConfiguration(MetricsConfiguration var1);

    public List<ConnectorServiceConfiguration> getConnectorServiceConfigurations();

    public List<SecuritySettingPlugin> getSecuritySettingPlugins();

    @Deprecated
    public ActiveMQMetricsPlugin getMetricsPlugin();

    public MetricsConfiguration getMetricsConfiguration();

    public Configuration setPasswordCodec(String var1);

    public String getPasswordCodec();

    public Configuration setMaskPassword(Boolean var1);

    public Boolean isMaskPassword();

    public Configuration setResolveProtocols(boolean var1);

    public TransportConfiguration[] getTransportConfigurations(String ... var1);

    public TransportConfiguration[] getTransportConfigurations(List<String> var1);

    public boolean isResolveProtocols();

    public Configuration copy() throws Exception;

    public Configuration setJournalLockAcquisitionTimeout(long var1);

    public long getJournalLockAcquisitionTimeout();

    public HAPolicyConfiguration getHAPolicyConfiguration();

    public Configuration setHAPolicyConfiguration(HAPolicyConfiguration var1);

    public void setBrokerInstance(File var1);

    public File getBrokerInstance();

    default public boolean isJDBC() {
        StoreConfiguration configuration = this.getStoreConfiguration();
        return configuration != null && configuration.getStoreType() == StoreConfiguration.StoreType.DATABASE;
    }

    public StoreConfiguration getStoreConfiguration();

    public Configuration setStoreConfiguration(StoreConfiguration var1);

    public boolean isPopulateValidatedUser();

    public Configuration setPopulateValidatedUser(boolean var1);

    public boolean isRejectEmptyValidatedUser();

    public Configuration setRejectEmptyValidatedUser(boolean var1);

    public String debugConnectors();

    public Configuration setConnectionTtlCheckInterval(long var1);

    public long getConnectionTtlCheckInterval();

    public URL getConfigurationUrl();

    public Configuration setConfigurationUrl(URL var1);

    public long getConfigurationFileRefreshPeriod();

    public Configuration setConfigurationFileRefreshPeriod(long var1);

    public long getGlobalMaxSize();

    public Configuration setGlobalMaxSize(long var1);

    public Configuration setGlobalMaxMessages(long var1);

    public long getGlobalMaxMessages();

    public int getMaxDiskUsage();

    public Configuration setMaxDiskUsage(int var1);

    public long getMinDiskFree();

    public Configuration setMinDiskFree(long var1);

    public ConfigurationImpl setInternalNamingPrefix(String var1);

    public Configuration setDiskScanPeriod(int var1);

    public int getDiskScanPeriod();

    public Configuration setNetworkCheckList(String var1);

    public String getNetworkCheckList();

    public Configuration setNetworkCheckURLList(String var1);

    public String getNetworkCheckURLList();

    public Configuration setNetworkCheckPeriod(long var1);

    public long getNetworkCheckPeriod();

    public Configuration setNetworkCheckTimeout(int var1);

    public int getNetworkCheckTimeout();

    @Deprecated
    public Configuration setNetworCheckNIC(String var1);

    public Configuration setNetworkCheckNIC(String var1);

    public String getNetworkCheckNIC();

    public String getNetworkCheckPingCommand();

    public Configuration setNetworkCheckPingCommand(String var1);

    public String getNetworkCheckPing6Command();

    public Configuration setNetworkCheckPing6Command(String var1);

    public String getInternalNamingPrefix();

    public int getPageSyncTimeout();

    public Configuration setPageSyncTimeout(int var1);

    public void registerBrokerPlugins(List<ActiveMQServerBasePlugin> var1);

    public void registerBrokerPlugin(ActiveMQServerBasePlugin var1);

    public void unRegisterBrokerPlugin(ActiveMQServerBasePlugin var1);

    public List<ActiveMQServerBasePlugin> getBrokerPlugins();

    public List<ActiveMQServerConnectionPlugin> getBrokerConnectionPlugins();

    public List<ActiveMQServerSessionPlugin> getBrokerSessionPlugins();

    public List<ActiveMQServerConsumerPlugin> getBrokerConsumerPlugins();

    public List<ActiveMQServerAddressPlugin> getBrokerAddressPlugins();

    public List<ActiveMQServerQueuePlugin> getBrokerQueuePlugins();

    public List<ActiveMQServerBindingPlugin> getBrokerBindingPlugins();

    public List<ActiveMQServerMessagePlugin> getBrokerMessagePlugins();

    public List<ActiveMQServerBridgePlugin> getBrokerBridgePlugins();

    public List<ActiveMQServerCriticalPlugin> getBrokerCriticalPlugins();

    public List<ActiveMQServerFederationPlugin> getBrokerFederationPlugins();

    public List<AMQPFederationBrokerPlugin> getBrokerAMQPFederationPlugins();

    public List<FederationConfiguration> getFederationConfigurations();

    public List<ActiveMQServerResourcePlugin> getBrokerResourcePlugins();

    public String getTemporaryQueueNamespace();

    public Configuration setTemporaryQueueNamespace(String var1);

    public Configuration setMqttSessionScanInterval(long var1);

    public long getMqttSessionScanInterval();

    public Configuration setMqttSessionStatePersistenceTimeout(long var1);

    public long getMqttSessionStatePersistenceTimeout();

    public boolean isSuppressSessionNotifications();

    public Configuration setSuppressSessionNotifications(boolean var1);

    default public String resolvePropertiesSources(String propertiesFileUrl) {
        return System.getProperty("broker.properties", propertiesFileUrl);
    }

    public String getStatus();

    public void setStatus(String var1);

    public String getLiteralMatchMarkers();

    public Configuration setLiteralMatchMarkers(String var1);

    public Configuration setLargeMessageSync(boolean var1);

    public boolean isLargeMessageSync();

    public String getViewPermissionMethodMatchPattern();

    public void setViewPermissionMethodMatchPattern(String var1);

    public boolean isManagementMessageRbac();

    public void setManagementMessageRbac(boolean var1);

    public String getManagementRbacPrefix();

    public void setManagementRbacPrefix(String var1);
}

