/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import org.HdrHistogram.ShadedDoubleHistogram;
import org.HdrHistogram.ShadedHistogram;

public abstract class ShadedEncodableHistogram {
    public abstract int getNeededByteBufferCapacity();

    public abstract int encodeIntoCompressedByteBuffer(ByteBuffer var1, int var2);

    public abstract long getStartTimeStamp();

    public abstract void setStartTimeStamp(long var1);

    public abstract long getEndTimeStamp();

    public abstract void setEndTimeStamp(long var1);

    public abstract String getTag();

    public abstract void setTag(String var1);

    public abstract double getMaxValueAsDouble();

    static ShadedEncodableHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) throws DataFormatException {
        int cookie = buffer.getInt(buffer.position());
        if (ShadedDoubleHistogram.isDoubleHistogramCookie(cookie)) {
            return ShadedDoubleHistogram.decodeFromCompressedByteBuffer(buffer, minBarForHighestTrackableValue);
        }
        return ShadedHistogram.decodeFromCompressedByteBuffer(buffer, minBarForHighestTrackableValue);
    }
}

