/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.spi.DelayedDropAction;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;

class SessionFactoryObserverForSchemaExport
implements SessionFactoryObserver {
    private final MetadataImplementor metadata;
    private DelayedDropAction delayedDropAction;

    SessionFactoryObserverForSchemaExport(MetadataImplementor metadata) {
        this.metadata = metadata;
    }

    @Override
    public void sessionFactoryCreated(SessionFactory factory) {
        SchemaManagementToolCoordinator.process(this.metadata, SessionFactoryObserverForSchemaExport.getRegistry(factory), factory.getProperties(), action -> {
            this.delayedDropAction = action;
        });
    }

    @Override
    public void sessionFactoryClosing(SessionFactory factory) {
        if (this.delayedDropAction != null) {
            this.delayedDropAction.perform(SessionFactoryObserverForSchemaExport.getRegistry(factory));
        }
    }

    private static ServiceRegistryImplementor getRegistry(SessionFactory factory) {
        return ((SessionFactoryImplementor)factory).getServiceRegistry();
    }
}

