/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.SignedBinary;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetResultSet;
import org.apache.derby.client.net.NetSqlca;
import org.apache.derby.client.net.Typdef;

class NetCursor
extends Cursor {
    NetResultSet netResultSet_;
    private NetAgent netAgent_;
    Typdef qrydscTypdef_;
    int maximumRowSize_;
    boolean blocking_;
    int[] typeToUseForComputingDataLength_;
    boolean[] isGraphic_;
    HashMap<Integer, Integer> extdtaPositions_;
    ArrayList<byte[]> extdtaData_;
    boolean rtnextrow_ = true;
    private boolean qryclsimpEnabled_;

    NetCursor(NetAgent netAgent) {
        super(netAgent);
        this.netAgent_ = netAgent;
        this.maximumRowSize_ = 0;
        this.extdtaPositions_ = new HashMap();
        this.extdtaData_ = new ArrayList();
    }

    NetCursor(NetAgent netAgent, int n) {
        this(netAgent);
        if (n == 9240) {
            this.blocking_ = false;
        } else if (n == 9239) {
            this.blocking_ = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean calculateColumnOffsetsForRow_(int n, boolean bl) throws SqlException, DisconnectException {
        int n2;
        int n3 = 255;
        int n4 = 255;
        int[] nArray = null;
        int[] nArray2 = null;
        boolean[] blArray = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.position_ == this.lastValidBytePosition_ && this.netResultSet_ != null && this.netResultSet_.scrollable_) {
            return false;
        }
        if (this.hasLobs_) {
            this.extdtaPositions_.clear();
        }
        NetSqlca[] netSqlcaArray = this.parseSQLCARD(this.qrydscTypdef_);
        n3 = this.readFdocaOneByte();
        if (netSqlcaArray != null) {
            for (n2 = 0; n2 < netSqlcaArray.length; ++n2) {
                int n5 = netSqlcaArray[n2].getSqlCode();
                if (n5 < 0) {
                    throw new SqlException(this.netAgent_.logWriter_, netSqlcaArray[n2]);
                }
                if (n5 == SqlCode.END_OF_DATA.getCode()) {
                    this.setAllRowsReceivedFromServer(true);
                    if (this.netResultSet_ == null || !netSqlcaArray[n2].containsSqlcax()) continue;
                    this.netResultSet_.setRowCountEvent(netSqlcaArray[n2].getRowCount());
                    continue;
                }
                if (this.netResultSet_ == null || n5 <= 0) continue;
                String string = netSqlcaArray[n2].getSqlState();
                if (!string.equals("02502") && !string.equals("rwupd")) {
                    this.netResultSet_.accumulateWarning(new SqlWarning(this.agent_.logWriter_, netSqlcaArray[n2]));
                    continue;
                }
                bl2 |= string.equals("02502");
                bl3 |= string.equals("rwupd");
            }
        }
        this.setIsUpdataDeleteHole(n, bl2);
        this.setIsRowUpdated(bl3);
        if (this.allRowsReceivedFromServer() && this.position_ == this.lastValidBytePosition_) {
            this.markNextRowPosition();
            this.makeNextRowPositionCurrent();
            return false;
        }
        if (n3 == 0) {
            this.incrementRowsReadEvent();
            if (this.netResultSet_ != null && this.netResultSet_.scrollable_) {
                nArray = this.allocateColumnDataPositionArray(n);
                nArray2 = this.allocateColumnDataComputedLengthArray(n);
                blArray = this.allocateColumnDataIsNullArray(n);
                this.setIsUpdataDeleteHole(n, false);
            } else {
                if (this.columnDataPosition_ == null || this.columnDataComputedLength_ == null || this.isNull_ == null) {
                    this.allocateColumnOffsetAndLengthArrays();
                }
                nArray = this.columnDataPosition_;
                nArray2 = this.columnDataComputedLength_;
                blArray = this.isNull_;
            }
            for (n2 = 0; n2 < this.columns_; ++n2) {
                if (this.nullable_[n2]) {
                    n4 = this.readFdocaOneByte(n2);
                }
                if (!this.nullable_[n2] || n4 >= 0 && n4 <= 127) {
                    blArray[n2] = false;
                    switch (this.typeToUseForComputingDataLength_[n2]) {
                        case 0: {
                            nArray[n2] = this.position_;
                            if (this.isGraphic_[n2]) {
                                nArray2[n2] = this.skipFdocaBytes(this.fdocaLength_[n2] * 2, n2);
                                break;
                            }
                            nArray2[n2] = this.skipFdocaBytes(this.fdocaLength_[n2], n2);
                            break;
                        }
                        case 1: {
                            nArray[n2] = this.position_;
                            int n6 = this.readFdocaTwoByteLength(n2);
                            if (this.isGraphic_[n2]) {
                                nArray2[n2] = this.skipFdocaBytes(n6 * 2, n2) + 2;
                                break;
                            }
                            nArray2[n2] = this.skipFdocaBytes(n6, n2) + 2;
                            break;
                        }
                        case 3: {
                            nArray[n2] = this.position_;
                            nArray2[n2] = this.skipFdocaBytes(this.getDecimalLength(n2), n2);
                            break;
                        }
                        case 4: {
                            nArray[n2] = this.position_;
                            nArray2[n2] = this.skipFdocaBytes(this.fdocaLength_[n2] & Short.MAX_VALUE, n2);
                            break;
                        }
                        case 2: {
                            nArray[n2] = this.position_;
                            int n6 = this.readFdocaOneByte(n2);
                            if (this.isGraphic_[n2]) {
                                nArray2[n2] = this.skipFdocaBytes(n6 * 2, n2) + 1;
                                break;
                            }
                            nArray2[n2] = this.skipFdocaBytes(n6, n2) + 1;
                            break;
                        }
                        default: {
                            nArray[n2] = this.position_;
                            if (this.isGraphic_[n2]) {
                                nArray2[n2] = this.skipFdocaBytes(this.fdocaLength_[n2] * 2, n2);
                                break;
                            }
                            nArray2[n2] = this.skipFdocaBytes(this.fdocaLength_[n2], n2);
                            break;
                        }
                    }
                    continue;
                }
                if ((n4 & 0x80) != 128) continue;
                blArray[n2] = true;
            }
            this.columnDataPosition_ = nArray;
            this.columnDataComputedLength_ = nArray2;
            this.isNull_ = blArray;
            if (this.allRowsReceivedFromServer()) return this.blocking_ || !this.allRowsReceivedFromServer() || n3 != 255;
            this.calculateLobColumnPositionsForRow();
            if (!this.blocking_ || !this.rtnextrow_ || this.netResultSet_.scrollable_ || this.extdtaPositions_.isEmpty()) return this.blocking_ || !this.allRowsReceivedFromServer() || n3 != 255;
            if (!bl) return false;
            this.netResultSet_.flowFetch();
            return this.blocking_ || !this.allRowsReceivedFromServer() || n3 != 255;
        } else {
            if (this.netResultSet_ == null || !this.netResultSet_.scrollable_ || !bl2) return this.blocking_ || !this.allRowsReceivedFromServer() || n3 != 255;
            this.setIsUpdataDeleteHole(n, true);
        }
        return this.blocking_ || !this.allRowsReceivedFromServer() || n3 != 255;
    }

    void scanDataBufferForEndOfData() throws SqlException {
        while (!this.allRowsReceivedFromServer() && this.position_ != this.lastValidBytePosition_) {
            this.stepNext(false);
        }
    }

    private int readFdocaInt() throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(4);
        int n = SignedBinary.getInt(this.dataBuffer_, this.position_);
        this.position_ += 4;
        return n;
    }

    private int readFdocaOneByte() throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(1);
        return this.dataBuffer_[this.position_++] & 0xFF;
    }

    private int readFdocaOneByte(int n) throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(1, n);
        return this.dataBuffer_[this.position_++] & 0xFF;
    }

    private byte[] readFdocaBytes(int n) throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(n);
        byte[] byArray = new byte[n];
        System.arraycopy(this.dataBuffer_, this.position_, byArray, 0, n);
        this.position_ += n;
        return byArray;
    }

    private int readFdocaTwoByteLength() throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(2);
        return ((this.dataBuffer_[this.position_++] & 0xFF) << 8) + ((this.dataBuffer_[this.position_++] & 0xFF) << 0);
    }

    private int readFdocaTwoByteLength(int n) throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(2, n);
        return ((this.dataBuffer_[this.position_++] & 0xFF) << 8) + ((this.dataBuffer_[this.position_++] & 0xFF) << 0);
    }

    private int skipFdocaBytes(int n) throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(n);
        this.position_ += n;
        return n;
    }

    private int skipFdocaBytes(int n, int n2) throws DisconnectException, SqlException {
        this.checkForSplitRowAndComplete(n, n2);
        this.position_ += n;
        return n;
    }

    private void shiftPartialRowToBeginning() {
        int n = this.lastValidBytePosition_ - this.currentRowPosition_;
        this.dataBufferStream_.reset();
        if (this.dataBuffer_ != null) {
            this.dataBufferStream_.write(this.dataBuffer_, this.currentRowPosition_, n);
        }
        for (int i = 0; i < n; ++i) {
            this.dataBuffer_[i] = this.dataBuffer_[this.currentRowPosition_ + i];
        }
        this.position_ = n - (this.lastValidBytePosition_ - this.position_);
        this.lastValidBytePosition_ = n;
    }

    private void adjustColumnOffsetsForColumnsPreviouslyCalculated(int n) {
        int n2 = 0;
        while (n2 <= n) {
            int n3 = n2++;
            this.columnDataPosition_[n3] = this.columnDataPosition_[n3] - this.currentRowPosition_;
        }
    }

    private void resetCurrentRowPosition() {
        this.currentRowPosition_ = 0;
    }

    void calculateLobColumnPositionsForRow() {
        int n = 0;
        for (int i = 0; i < this.columns_; ++i) {
            if (!this.isNonTrivialDataLob(i) || this.locator(i + 1) != -1) continue;
            this.extdtaPositions_.put(i + 1, n++);
        }
    }

    private boolean isNonTrivialDataLob(int n) {
        long l = 0L;
        if (this.isNull_[n] || this.jdbcTypes_[n] != 2004 && this.jdbcTypes_[n] != 2005) {
            return false;
        }
        int n2 = this.columnDataPosition_[n];
        if ((this.dataBuffer_[n2] & 0x80) == 128) {
            l = -1L;
        } else {
            byte[] byArray = new byte[this.columnDataComputedLength_[n]];
            byte[] byArray2 = new byte[8];
            System.arraycopy(this.dataBuffer_, n2, byArray, 0, this.columnDataComputedLength_[n]);
            int n3 = 0;
            for (int i = 8 - this.columnDataComputedLength_[n]; i < 8; ++i) {
                byArray2[i] = byArray[n3];
                ++n3;
            }
            l = SignedBinary.getLong(byArray2, 0);
        }
        return l != 0L;
    }

    @Override
    protected void clearLobData_() {
        this.extdtaData_.clear();
        this.extdtaPositions_.clear();
    }

    private NetSqlca[] parseSQLCARD(Typdef typdef) throws DisconnectException, SqlException {
        return this.parseSQLCAGRP(typdef);
    }

    private NetSqlca[] parseSQLCAGRP(Typdef typdef) throws DisconnectException, SqlException {
        NetSqlca[] netSqlcaArray;
        if (this.readFdocaOneByte() == 255) {
            return null;
        }
        int n = this.readFdocaInt();
        byte[] byArray = this.readFdocaBytes(5);
        byte[] byArray2 = this.readFdocaBytes(8);
        NetSqlca netSqlca = new NetSqlca((ClientConnection)this.netAgent_.netConnection_, n, byArray, byArray2);
        this.parseSQLCAXGRP(typdef, netSqlca);
        NetSqlca[] netSqlcaArray2 = this.parseSQLDIAGGRP();
        if (netSqlcaArray2 != null) {
            netSqlcaArray = new NetSqlca[netSqlcaArray2.length + 1];
            System.arraycopy(netSqlcaArray2, 0, netSqlcaArray, 1, netSqlcaArray2.length);
        } else {
            netSqlcaArray = new NetSqlca[]{netSqlca};
        }
        return netSqlcaArray;
    }

    private void parseSQLCAXGRP(Typdef typdef, NetSqlca netSqlca) throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            netSqlca.setContainsSqlcax(false);
            return;
        }
        int[] nArray = new int[6];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.readFdocaInt();
        }
        byte[] byArray = this.readFdocaBytes(11);
        this.parseVCS(typdef);
        int n = this.readFdocaTwoByteLength();
        byte[] byArray2 = null;
        int n2 = 0;
        if (n != 0) {
            byArray2 = this.readFdocaBytes(n);
            n2 = typdef.getCcsidMbc();
            this.skipFdocaBytes(2);
        } else {
            n = this.readFdocaTwoByteLength();
            byArray2 = this.readFdocaBytes(n);
            n2 = typdef.getCcsidSbc();
        }
        netSqlca.setSqlerrd(nArray);
        netSqlca.setSqlwarnBytes(byArray);
        netSqlca.setSqlerrmcBytes(byArray2);
    }

    private NetSqlca[] parseSQLDIAGGRP() throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            return null;
        }
        this.parseSQLDIAGSTT();
        NetSqlca[] netSqlcaArray = this.parseSQLDIAGCI();
        this.parseSQLDIAGCN();
        return netSqlcaArray;
    }

    private void parseSQLDIAGSTT() throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            return;
        }
        this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, new ClientMessageId("0A000.C.6"), "parseSQLDIAGSTT"));
    }

    private NetSqlca[] parseSQLDIAGCI() throws DisconnectException, SqlException {
        int n = this.readFdocaTwoByteLength();
        NetSqlca[] netSqlcaArray = null;
        if (n != 0) {
            netSqlcaArray = new NetSqlca[n];
        }
        for (int i = 0; i < n; ++i) {
            netSqlcaArray[i] = this.parseSQLDCROW();
        }
        return netSqlcaArray;
    }

    private void parseSQLDIAGCN() throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            return;
        }
        this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, new ClientMessageId("0A000.C.6"), "parseSQLDIAGCN"));
    }

    private NetSqlca parseSQLDCGRP() throws DisconnectException, SqlException {
        int n = this.readFdocaInt();
        String string = this.readFdocaString(5, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        int n2 = this.readFdocaInt();
        this.skipFdocaBytes(12);
        NetSqlca netSqlca = new NetSqlca((ClientConnection)this.netAgent_.netConnection_, n, string, (byte[])null);
        this.skipFdocaBytes(49);
        this.parseSQLDCTOKS();
        String string2 = this.parseVCS(this.qrydscTypdef_);
        if (string2 != null) {
            netSqlca.setSqlerrmcBytes(string2.getBytes());
        }
        this.skipFdocaBytes(12);
        this.parseSQLDCXGRP();
        return netSqlca;
    }

    private NetSqlca parseSQLDCROW() throws DisconnectException, SqlException {
        return this.parseSQLDCGRP();
    }

    private void parseSQLDCTOKS() throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            return;
        }
        this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, new ClientMessageId("0A000.C.6"), "parseSQLDCTOKS"));
    }

    private void parseSQLDCXGRP() throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            return;
        }
        this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, new ClientMessageId("0A000.C.6"), "parseSQLDCXGRP"));
    }

    private String parseVCS(Typdef typdef) throws DisconnectException, SqlException {
        return this.readFdocaString(this.readFdocaTwoByteLength(), typdef.getCcsidSbcEncoding());
    }

    private String readFdocaString(int n, Charset charset) throws SqlException {
        if (n == 0) {
            return null;
        }
        this.checkForSplitRowAndComplete(n);
        String string = new String(this.dataBuffer_, this.position_, n, charset);
        this.position_ += n;
        return string;
    }

    void allocateColumnOffsetAndLengthArrays() {
        this.columnDataPosition_ = new int[this.columns_];
        this.columnDataComputedLength_ = new int[this.columns_];
        this.isNull_ = new boolean[this.columns_];
    }

    private byte[] findExtdtaData(int n) {
        byte[] byArray = null;
        Integer n2 = this.extdtaPositions_.get(n);
        if (n2 != null) {
            byArray = this.extdtaData_.get(n2);
        }
        return byArray;
    }

    @Override
    protected int locator(int n) {
        int n2 = this.get_INTEGER(n);
        if (n2 == 32768 || n2 == 32770 || n2 == 32772 || n2 == 32774 || n2 == 32776 || n2 == 0) {
            return -1;
        }
        return n2;
    }

    @Override
    public ClientBlob getBlobColumn_(int n, Agent agent, boolean bl) throws SqlException {
        int n2;
        if (bl && this.netResultSet_ != null) {
            this.netResultSet_.markLOBAsPublished(n);
        }
        if ((n2 = this.locator(n)) > 0) {
            return new ClientBlob(agent, n2);
        }
        int n3 = n - 1;
        ClientBlob clientBlob = null;
        byte[] byArray = this.findExtdtaData(n);
        if (byArray != null) {
            int n4 = !this.nullable_[n3] ? 0 : 1;
            clientBlob = new ClientBlob(byArray, agent, n4);
        } else {
            clientBlob = new ClientBlob(new byte[0], agent, 0);
        }
        return clientBlob;
    }

    @Override
    public ClientClob getClobColumn_(int n, Agent agent, boolean bl) throws SqlException {
        int n2;
        if (bl && this.netResultSet_ != null) {
            this.netResultSet_.markLOBAsPublished(n);
        }
        if ((n2 = this.locator(n)) > 0) {
            return new ClientClob(agent, n2);
        }
        int n3 = n - 1;
        ClientClob clientClob = null;
        byte[] byArray = this.findExtdtaData(n);
        if (byArray != null) {
            int n4 = !this.nullable_[n3] ? 0 : 1;
            clientClob = new ClientClob(agent, byArray, this.charset_[n3], n4);
        } else {
            clientClob = new ClientClob(agent, "");
        }
        return clientClob;
    }

    void initializeColumnInfoArrays(Typdef typdef, int n) throws DisconnectException {
        this.qrydscTypdef_ = typdef;
        this.setNumberOfColumns(n);
        this.fdocaLength_ = new int[n];
        this.isGraphic_ = new boolean[n];
        this.typeToUseForComputingDataLength_ = new int[n];
    }

    @Override
    protected void getMoreData_() throws SqlException {
        if (this.netResultSet_.resultSetType_ == 1003) {
            this.resetDataBuffer();
        }
        this.netResultSet_.flowFetch();
    }

    @Override
    public void nullDataForGC() {
        super.nullDataForGC();
        this.qrydscTypdef_ = null;
        this.typeToUseForComputingDataLength_ = null;
        this.isGraphic_ = null;
        if (this.extdtaPositions_ != null) {
            this.extdtaPositions_.clear();
        }
        this.extdtaPositions_ = null;
        if (this.extdtaData_ != null) {
            this.extdtaData_.clear();
        }
        this.extdtaData_ = null;
    }

    private void checkForSplitRowAndComplete(int n, int n2) throws SqlException {
        while (this.position_ + n > this.lastValidBytePosition_) {
            this.checkAndThrowReceivedEndqryrm();
            int n3 = this.completeSplitRow(n2);
            this.checkAndThrowReceivedEndqryrm(n3);
        }
    }

    private void checkForSplitRowAndComplete(int n) throws SqlException {
        this.checkForSplitRowAndComplete(n, -1);
    }

    private void checkAndThrowReceivedEndqryrm() throws SqlException {
        if (!this.netResultSet_.openOnServer_) {
            SqlException sqlException = null;
            int n = Utils.getSqlcodeFromSqlca(this.netResultSet_.queryTerminatingSqlca_);
            sqlException = n < 0 ? new SqlException(this.agent_.logWriter_, this.netResultSet_.queryTerminatingSqlca_) : new SqlException(this.agent_.logWriter_, new ClientMessageId("XN008.S"), new Object[0]);
            try {
                this.netResultSet_.closeX();
            }
            catch (SqlException sqlException2) {
                sqlException.setNextException(sqlException2);
            }
            throw sqlException;
        }
    }

    private void checkAndThrowReceivedEndqryrm(int n) throws SqlException {
        if (this.lastValidBytePosition_ > n) {
            return;
        }
        this.checkAndThrowReceivedEndqryrm();
    }

    private int completeSplitRow(int n) throws DisconnectException, SqlException {
        int n2 = 0;
        if (this.netResultSet_ != null && this.netResultSet_.scrollable_) {
            n2 = this.lastValidBytePosition_;
            this.netResultSet_.flowFetchToCompleteRowset();
        } else {
            this.shiftPartialRowToBeginning();
            this.adjustColumnOffsetsForColumnsPreviouslyCalculated(n);
            this.resetCurrentRowPosition();
            n2 = this.lastValidBytePosition_;
            this.netResultSet_.flowFetch();
        }
        return n2;
    }

    private int[] allocateColumnDataPositionArray(int n) {
        int[] nArray;
        if (this.columnDataPositionCache_.size() == n) {
            nArray = new int[this.columns_];
            this.columnDataPositionCache_.add(nArray);
        } else {
            nArray = (int[])this.columnDataPositionCache_.get(n);
        }
        return nArray;
    }

    private int[] allocateColumnDataComputedLengthArray(int n) {
        int[] nArray;
        if (this.columnDataLengthCache_.size() == n) {
            nArray = new int[this.columns_];
            this.columnDataLengthCache_.add(nArray);
        } else {
            nArray = (int[])this.columnDataLengthCache_.get(n);
        }
        return nArray;
    }

    private boolean[] allocateColumnDataIsNullArray(int n) {
        boolean[] blArray;
        if (this.columnDataIsNullCache_.size() <= n) {
            blArray = new boolean[this.columns_];
            this.columnDataIsNullCache_.add(blArray);
        } else {
            blArray = (boolean[])this.columnDataIsNullCache_.get(n);
        }
        return blArray;
    }

    protected int getDecimalLength(int n) {
        return ((this.fdocaLength_[n] >> 8 & 0xFF) + 2) / 2;
    }

    @Override
    public final void setAllRowsReceivedFromServer(boolean bl) {
        if (bl && this.qryclsimpEnabled_) {
            this.netResultSet_.markClosedOnServer();
        }
        super.setAllRowsReceivedFromServer(bl);
    }

    final void setQryclsimpEnabled(boolean bl) {
        this.qryclsimpEnabled_ = bl;
    }

    final boolean getQryclsimpEnabled() {
        return this.qryclsimpEnabled_;
    }
}

