/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalQueueBinding
implements QueueBinding {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SimpleString address;
    private final Queue queue;
    private final SimpleString clusterName;
    private SimpleString name;

    public LocalQueueBinding(SimpleString address, Queue queue, SimpleString nodeID) {
        this.address = address;
        this.queue = queue;
        this.name = queue.getName();
        this.clusterName = queue.getName().concat(nodeID);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Long getID() {
        return this.queue.getID();
    }

    @Override
    public Filter getFilter() {
        return this.queue.getFilter();
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public Bindable getBindable() {
        return this.queue;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public SimpleString getRoutingName() {
        if (this.queue.getRoutingType() == RoutingType.ANYCAST) {
            return this.address;
        }
        return this.name;
    }

    @Override
    public SimpleString getUniqueName() {
        return this.queue.getName();
    }

    @Override
    public SimpleString getClusterName() {
        return this.clusterName;
    }

    @Override
    public boolean isExclusive() {
        return false;
    }

    @Override
    public int getDistance() {
        return 0;
    }

    @Override
    public boolean isHighAcceptPriority(Message message) {
        return this.queue.hasMatchingConsumer(message);
    }

    @Override
    public void unproposed(SimpleString groupID) {
        this.queue.unproposed(groupID);
    }

    @Override
    public void route(Message message, RoutingContext context) throws Exception {
        if (this.isMatchRoutingType(context)) {
            logger.trace("adding routing {} on message {}", (Object)this.queue.getID(), (Object)message);
            this.queue.route(message, context);
        } else {
            logger.trace("routing {} is ignored as routing type did not match", (Object)this.queue.getID());
        }
    }

    @Override
    public void routeWithAck(Message message, RoutingContext context) throws Exception {
        if (this.isMatchRoutingType(context)) {
            logger.trace("Message {} routed with ack on queue {}", (Object)message, (Object)this.queue.getID());
            this.queue.routeWithAck(message, context);
        }
    }

    private boolean isMatchRoutingType(RoutingContext context) {
        return context.getRoutingType() == null || context.getRoutingType() == this.queue.getRoutingType();
    }

    public boolean isQueueBinding() {
        return true;
    }

    @Override
    public int consumerCount() {
        return this.queue.getConsumerCount();
    }

    @Override
    public BindingType getType() {
        return BindingType.LOCAL_QUEUE;
    }

    @Override
    public void close() throws Exception {
        this.queue.close();
    }

    public String toString() {
        return "LocalQueueBinding [address=" + this.address + ", queue=" + this.queue + ", filter=" + this.getFilter() + ", name=" + this.name + ", clusterName=" + this.clusterName + "]";
    }

    @Override
    public String toManagementString() {
        return this.getClass().getSimpleName() + " [address=" + this.address + ", queue=" + this.queue + "]";
    }

    @Override
    public boolean isConnected() {
        return true;
    }
}

