/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class OAuth2ClientCredentialsGrantRequestEntityConverter
extends AbstractOAuth2AuthorizationGrantRequestEntityConverter<OAuth2ClientCredentialsGrantRequest> {
    @Override
    protected MultiValueMap<String, String> createParameters(OAuth2ClientCredentialsGrantRequest clientCredentialsGrantRequest) {
        ClientRegistration clientRegistration = clientCredentialsGrantRequest.getClientRegistration();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"grant_type", (Object)clientCredentialsGrantRequest.getGrantType().getValue());
        if (!CollectionUtils.isEmpty(clientRegistration.getScopes())) {
            parameters.add((Object)"scope", (Object)StringUtils.collectionToDelimitedString(clientRegistration.getScopes(), (String)" "));
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            parameters.add((Object)"client_id", (Object)clientRegistration.getClientId());
            parameters.add((Object)"client_secret", (Object)clientRegistration.getClientSecret());
        }
        return parameters;
    }
}

